/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.pattern;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ExclusiveBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ForkBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.IfBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.LoopBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ScopeBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.SequenceBehaviourImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

public class CreationPatternFactory {
    private static CreationPatternFactory instance;

    private CreationPatternFactory() {
    }

    public static CreationPatternFactory getInstance() {
        if (instance == null) {
            instance = new CreationPatternFactory();
        }
        return instance;
    }

    public Node createSequencePattern(String name, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        try {
            if (scope == null) {
                throw new CoreException("scope cannot be null");
            }
            parentNode = scope.createNode(name, SequenceBehaviourImpl.class, null);
            if (childNodes != null) {
                Iterator<Node> it = childNodes.iterator();
                Node source = null;
                Node target = null;
                Node lastNode = null;
                Component sourceComp = null;
                Component targetComp = null;
                Component lastComp = null;
                while (it.hasNext()) {
                    source = it.next();
                    sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)source, "service");
                    String sourceName = SCAHelper.getSCAHelper().getName(sourceComp);
                    if (lastNode != null) {
                        scope.linkedBrotherNodes(lastNode, source);
                    }
                    if (it.hasNext()) {
                        target = it.next();
                        targetComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)target, "service");
                        scope.linkedBrotherNodes(source, target);
                        lastNode = target;
                        lastComp = targetComp;
                        continue;
                    }
                    lastNode = null;
                    lastComp = null;
                }
                if (childNodes != null) {
                    for (Node children : childNodes) {
                        scope.linkedChildNodeToParent(parentNode, children);
                    }
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return parentNode;
    }

    public Node createScopePattern(String name, Scope scope) throws CoreException {
        Scope underscope = null;
        try {
            Behaviour behaviour;
            if (scope == null) {
                throw new CoreException("scope cannot be null");
            }
            Component underscopeComp = SCAHelper.getSCAHelper().createNewComponent(ScopeImpl.class.getName(), null);
            SCAHelper.getSCAHelper().addComponent(underscopeComp, scope.getComponent(), null);
            SCAContentController scacc = (SCAContentController)underscopeComp.getFcInterface("/sca-content-controller");
            try {
                underscope = (Scope)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            underscope.setName(name);
            if (!scope.getLogger().getName().equals(ScopeImpl.class.getName())) {
                underscope.setLog(scope.getLogger());
            }
            SCAHelper.getSCAHelper().startComponent(underscopeComp);
            underscope = (Node)underscopeComp.getFcInterface("service");
            Component fractalActivity = SCAHelper.getSCAHelper().createNewComponent(ScopeBehaviourImpl.class.getName(), null);
            SCAHelper.getSCAHelper().changeName(fractalActivity, String.valueOf(ScopeBehaviourImpl.class.getSimpleName()) + "4" + SCAHelper.getSCAHelper().getName(underscopeComp));
            SCAHelper.getSCAHelper().addComponent(fractalActivity, scope.getComponent(), null);
            scacc = (SCAContentController)fractalActivity.getFcInterface("/sca-content-controller");
            try {
                behaviour = (Behaviour)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            if (!scope.getLogger().getName().equals(ScopeImpl.class.getName())) {
                behaviour.setLog(scope.getLogger());
            }
            behaviour = (Behaviour)fractalActivity.getFcInterface("service");
            scope.linkedNodeAndFunctionnalBehaviour((Node)underscope, behaviour);
            underscope.setActivity(behaviour);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return underscope;
    }

    public Node createIfPattern(String name, List<ConditionalExpression> expressions, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        if (scope == null) {
            throw new CoreException("scope cannot be null");
        }
        if (expressions == null || expressions.size() == 0 || childNodes.size() == expressions.size() && childNodes.size() == expressions.size() + 1) {
            throw new CoreException("Invalid if pattern");
        }
        HashMap<String, List<ConditionalExpression>> context = new HashMap<String, List<ConditionalExpression>>();
        context.put("conditions", expressions);
        parentNode = scope.createNode(name, IfBehaviourImpl.class, context);
        if (childNodes != null) {
            for (Node children : childNodes) {
                scope.linkedChildNodeToParent(parentNode, children);
            }
        }
        return parentNode;
    }

    public Node createSeveralReceiversPattern(String name, List<ReceiverBehaviour> receivers, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        try {
            if (scope == null) {
                throw new CoreException("scope cannot be null");
            }
            if (receivers == null || receivers.size() == 0 || childNodes.size() != receivers.size()) {
                throw new CoreException("Invalid several receivers pattern");
            }
            ArrayList variableNames = new ArrayList();
            for (ReceiverBehaviour receiver : receivers) {
                variableNames.addAll((Collection)SCAHelper.getSCAHelper().getPropertyValue(receiver.getComponent(), "variableNames", List.class));
            }
            HashMap context = new HashMap();
            context.put("variableNames", variableNames);
            MessageMatcher matcher = (MessageMatcher)SCAHelper.getSCAHelper().getPropertyValue(receivers.get(0).getComponent(), "messageMatcher", MessageMatcher.class);
            for (ReceiverBehaviour receiver : receivers) {
                if (matcher == SCAHelper.getSCAHelper().getPropertyValue(receiver.getComponent(), "messageMatcher", MessageMatcher.class)) continue;
                throw new CoreException("Sorry but all receivers must have the same message matcher");
            }
            context.put("messageMatcher", matcher);
            ArrayList correlationsMatcher = null;
            for (ReceiverBehaviour receiver : receivers) {
                if (SCAHelper.getSCAHelper().getPropertyValue(receiver.getComponent(), "correlationsMatcher", List.class) == null) continue;
                if (correlationsMatcher == null) {
                    correlationsMatcher = new ArrayList();
                }
                correlationsMatcher.addAll((Collection)SCAHelper.getSCAHelper().getPropertyValue(receiver.getComponent(), "correlationsMatcher", List.class));
            }
            context.put("correlationsMatcher", correlationsMatcher);
            parentNode = scope.createNode(name, ReceiverBehaviourImpl.class, context);
            if (childNodes != null) {
                for (Node children : childNodes) {
                    scope.linkedChildNodeToParent(parentNode, children);
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return parentNode;
    }

    public Node createLoopPattern(String name, ConditionalExpression condition, boolean applyConditionAtBegin, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        try {
            if (scope == null) {
                throw new CoreException("scope cannot be null");
            }
            if (condition == null) {
                throw new CoreException("condition cannot be null");
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("condition", condition);
            context.put("applyConditionAtBegin", applyConditionAtBegin);
            parentNode = scope.createNode(name, LoopBehaviourImpl.class, context);
            if (childNodes != null) {
                Iterator<Node> it = childNodes.iterator();
                Node source = null;
                Node target = null;
                Node lastNode = null;
                Component sourceComp = null;
                Component targetComp = null;
                Component lastComp = null;
                String transitionName = "t";
                while (it.hasNext()) {
                    source = it.next();
                    sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)source, "service");
                    if (lastNode != null) {
                        scope.linkedBrotherNodes(lastNode, source);
                    }
                    if (it.hasNext()) {
                        target = it.next();
                        targetComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)target, "service");
                        scope.linkedBrotherNodes(source, target);
                        lastNode = target;
                        lastComp = targetComp;
                        continue;
                    }
                    lastNode = null;
                    lastComp = null;
                }
                if (childNodes != null) {
                    for (Node children : childNodes) {
                        scope.linkedChildNodeToParent(parentNode, children);
                    }
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return parentNode;
    }

    public Node createForkPattern(String name, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        if (scope == null) {
            throw new CoreException("scope cannot be null");
        }
        parentNode = scope.createNode(name, ForkBehaviourImpl.class, null);
        if (childNodes != null) {
            for (Node children : childNodes) {
                scope.linkedChildNodeToParent(parentNode, children);
            }
        }
        return parentNode;
    }

    public Node createExclusivePattern(String name, Map<Node, Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        if (scope == null) {
            throw new CoreException("scope cannot be null");
        }
        HashMap<String, Set<Node>> context = new HashMap<String, Set<Node>>();
        if (childNodes != null) {
            context.put("triggeringNodes", childNodes.keySet());
        }
        parentNode = scope.createNode(name, ExclusiveBehaviourImpl.class, context);
        if (childNodes != null) {
            HashMap<WaitBehaviour, Node> waitingNodes = new HashMap<WaitBehaviour, Node>();
            for (Node child : childNodes.keySet()) {
                try {
                    Component comp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)child, "service");
                    SCAHelper.getSCAHelper().startComponent(comp);
                }
                catch (SCAException e) {
                    throw new CoreException((Throwable)e);
                }
                if (!(child.getBehaviour() instanceof WaitBehaviour)) continue;
                waitingNodes.put((WaitBehaviour)child.getBehaviour(), child);
            }
            if (!waitingNodes.isEmpty()) {
                Node fastest = this.findFastestWaitingNode(waitingNodes, scope);
                for (Node waitingNode : waitingNodes.values()) {
                    if (waitingNode.equals(fastest)) continue;
                    childNodes.remove(waitingNode);
                }
            }
            for (Node child : childNodes.keySet()) {
                scope.linkedChildNodeToParent(parentNode, child);
                Node follower = childNodes.get(child);
                if (follower == null) continue;
                scope.linkedChildNodeToParent(parentNode, follower);
            }
        }
        return parentNode;
    }

    private Node findFastestWaitingNode(Map<WaitBehaviour, Node> waitingNodes, Scope scope) throws CoreException {
        HashMap<Long, Node> times = new HashMap<Long, Node>();
        for (WaitBehaviour alarm : waitingNodes.keySet()) {
            Long time;
            try {
                Component comp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)alarm, "service");
                SCAHelper.getSCAHelper().startComponent(comp);
            }
            catch (SCAException e) {
                throw new CoreException((Throwable)e);
            }
            if (alarm.getDuration() != null) {
                time = (Long)alarm.getDuration().evaluate(null);
                if (time <= 0L) continue;
                times.put(time, waitingNodes.get(alarm));
                continue;
            }
            if (alarm.getDate() == null || (time = Long.valueOf(((Date)alarm.getDate().evaluate(null)).getTime())) <= 0L) continue;
            times.put(time, waitingNodes.get(alarm));
        }
        if (times.isEmpty()) {
            throw new CoreException("There is no valid waiting expression for this exclusive pattern.");
        }
        return (Node)times.get(Collections.min(times.keySet()));
    }
}

