/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.behaviour;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.AssignementExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.AssignBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.SenderBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.ExternalMessageImpl;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.StringVariableImpl;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class AssignBehaviourTest {
    @Test
    public void testAssigner() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 1, MemoryReceiverImpl.class, 1, SysoutSenderImpl.class, null);
        Engine engine = core.getEngine();
        StringVariableImpl v1 = new StringVariableImpl();
        v1.setQName(new QName("v1"));
        System.out.println("V1 : " + (Object)((Object)v1));
        StringVariableImpl v2 = new StringVariableImpl();
        v2.setQName(new QName("v2"));
        System.out.println("V2 : " + (Object)((Object)v2));
        ExternalMessageImpl message = new ExternalMessageImpl();
        message.setContent((Object)"hello world!");
        message.setQName(v1.getQName());
        ((Receiver)core.getExternalEnvironment().getReceivers().get(0)).accept((ExternalMessage)message, null);
        Process process = engine.createNewEmptyProcessInstance(new QName("receiveProcess"), null);
        process.setAssigner((Assigner)new SimpleVariableAssigner());
        process.getVariables().put(v1.getQName(), v1);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("variableNames", Arrays.asList(v1.getQName()));
        Node receiver = process.createNode("receive", ReceiverBehaviourImpl.class, context);
        context = new HashMap();
        context.put("assignements", Arrays.asList(new SimpleAssignementExpressionImpl((Expression)v2, (Expression)v1)));
        Node assigner = process.createNode("assign", AssignBehaviourImpl.class, context);
        context = new HashMap();
        context.put("kind", SenderBehaviour.Kind.ASYNCHRONOUS);
        context.put("inputVariableName", v2.getQName());
        context.put("outputVariableName", v2.getQName());
        Node sender = process.createNode("sender", SenderBehaviourImpl.class, context);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(receiver);
        childNodes.add(assigner);
        childNodes.add(sender);
        Node sequence = CreationPatternFactory.getInstance().createSequencePattern("seq", childNodes, (Scope)process);
        process.setInitialNode(sequence);
        process.getVariables().put(new QName("v2"), v2);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution main = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)main, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        main.runStepByStep();
        main.signal();
        main.signal();
        engine.flushMessagesInRegistry();
        main.signal();
        main.signal();
        main.signal();
        main.signal();
        main.signal();
        main.signal();
        main.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
    }

    public class SimpleAssignementExpressionImpl
    implements AssignementExpression {
        Expression left;
        Expression right;

        public SimpleAssignementExpressionImpl(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        public Expression getLeft() {
            return this.left;
        }

        public Expression getRight() {
            return this.right;
        }

        public void setLeft(Expression left) {
            this.left = left;
        }

        public void setRight(Expression right) {
            this.right = right;
        }

        public void setLog(Logger logger) {
        }
    }

    public static final class SimpleVariableAssigner
    implements Assigner {
        public Expression affect(Scope scope, Expression left, Expression right) throws CoreException {
            Variable vleft = scope.findVariable(new QName(left.getContent().toString()));
            if (vleft == null) {
                throw new CoreException("Impossible to find in process, the variable used in the received : " + left.getContent());
            }
            Variable vright = scope.findVariable(new QName(right.getContent().toString()));
            if (vright == null) {
                throw new CoreException("Impossible to find in process, the variable used in the received : " + right.getContent());
            }
            System.out.println("left = " + vleft);
            System.out.println("left = " + vleft.getValue());
            System.out.println("right = " + vright);
            System.out.println("right = " + vright.getValue().getContent());
            vleft.setValue(vright.getValue());
            scope.setVariable(vleft);
            return vleft;
        }

        public void setLog(Logger logger) {
        }
    }
}

