/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.marshalling;

import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.marshalling.factory.ExternalMessageFactoryImpl;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import junit.framework.Assert;
import org.junit.Test;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ViperExternalMessageMarshallingTest {
    private Logger log = Logger.getLogger(this.getClass().getSimpleName());
    private static final String ns = "http://easyviper/test";

    private ExternalMessage<Element> createExternalMessage() throws CoreException, ParserConfigurationException {
        ExternalMessage mess = null;
        ExternalMessageFactoryImpl messFactory = new ExternalMessageFactoryImpl();
        mess = (ExternalMessage)messFactory.create();
        QName qnameTest = new QName(ns, "myVar");
        mess.setQName(qnameTest);
        mess.setEndpoint("myEndpoint");
        mess.setOperationName("myOperation");
        mess.setService(new QName(ns, "myService"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = factory.newDocumentBuilder().newDocument();
        Element content = doc.createElementNS("urn:namespaceMessageContent", "content");
        doc.appendChild(content);
        Element root = doc.createElementNS("urn:namespaceMessageContent", "root");
        content.appendChild(root);
        Element node1 = doc.createElementNS("urn:namespaceMessageContent", "node1");
        node1.setTextContent("node1 text content");
        root.appendChild(node1);
        mess.setContent((Object)doc.getDocumentElement());
        return mess;
    }

    @Test
    public void testCreateMarshalling() {
        this.log.finest("Creation test ...");
        try {
            ExternalMessage<Element> mess = this.createExternalMessage();
            Assert.assertEquals((Object)new QName(ns, "myVar"), (Object)mess.getQName());
        }
        catch (CoreException e) {
            e.printStackTrace();
            Assert.fail((String)("=>testCreate: \n" + e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            Assert.fail((String)("=>testCreate: \n" + e.getMessage()));
        }
    }

    @Test
    public void testWriteMarshalling() {
        try {
            ExternalMessage<Element> mess = this.createExternalMessage();
            this.log.finest("write test");
            ExternalMessageFactoryImpl messFactory = new ExternalMessageFactoryImpl();
            Document messAsDoc = messFactory.getDocument(mess);
            String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ns2:externalmessage xmlns:ns2=\"http://ebmwebsourcing.com/easyviper/model/light\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n  <ns2:qname xmlns=\"http://easyviper/test\">myVar</ns2:qname>\n  <ns2:endpoint>myEndpoint</ns2:endpoint>\n  <ns2:service xmlns=\"http://easyviper/test\">myService</ns2:service>\n  <ns2:operation>myOperation</ns2:operation>\n  <ns2:content>\n    <root:root xmlns:root=\"urn:namespaceMessageContent\" xmlns=\"urn:namespaceMessageContent\">\n      <node1>node1 text content</node1>\n    </root:root>\n  </ns2:content>\n</ns2:externalmessage>";
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expectedDoc, (String)XMLPrettyPrinter.prettyPrint((Document)messAsDoc)));
        }
        catch (CoreException e) {
            e.printStackTrace();
            Assert.fail((String)("==testWrite\n" + e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            Assert.fail((String)("==testWrite\n" + e.getMessage()));
        }
    }

    @Test
    public void testReadMarshalling() {
        try {
            ExternalMessageFactoryImpl messFactory = new ExternalMessageFactoryImpl();
            ExternalMessage<Element> messExpected = this.createExternalMessage();
            Document messageExpectedAsDoc = messFactory.getDocument(messExpected);
            System.out.println("messageExpectedAsDoc: \n" + XMLPrettyPrinter.prettyPrint((Document)messageExpectedAsDoc));
            ExternalMessage mess = (ExternalMessage)messFactory.read(messageExpectedAsDoc);
            Document messageAsDoc = messFactory.getDocument((Object)mess);
            System.out.println("messageAsDoc: \n" + XMLPrettyPrinter.prettyPrint((Document)messageAsDoc));
            Assert.assertEquals((String)mess.getEndpoint(), (String)messExpected.getEndpoint());
            Assert.assertEquals((String)mess.getOperationName(), (String)messExpected.getOperationName());
            Assert.assertEquals((Object)mess.getQName(), (Object)messExpected.getQName());
            Assert.assertEquals((Object)mess.getService(), (Object)messExpected.getService());
            DOMSource source = new DOMSource(messageAsDoc);
            InputSource isou = SourceHelper.convertDOMSource2InputSource((DOMSource)source);
            InputStream is1 = isou.getByteStream();
            DOMSource source2 = new DOMSource(messageExpectedAsDoc);
            InputSource isou2 = SourceHelper.convertDOMSource2InputSource((DOMSource)source2);
            InputStream is2 = isou2.getByteStream();
            Assert.assertTrue((boolean)XMLComparator.isEquivalent((InputStream)is1, (InputStream)is2));
        }
        catch (CoreException e) {
            e.printStackTrace();
            Assert.fail((String)("==testRead\n" + e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            Assert.fail((String)("==testRead\n" + e.getMessage()));
        }
        catch (XmlException e) {
            e.printStackTrace();
            Assert.fail((String)("==testRead\n" + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("==testRead\n" + e.getMessage()));
        }
    }
}

