/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.expression.AbstractExpressionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class LoopPatternTest {
    @Test
    public void testWhilePattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        CounterCondition condition = new CounterCondition(3);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("second", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("third", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createLoopPattern("while", (ConditionalExpression)condition, true, childNodes, (Scope)process);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testWhileWithoutUnderActivityPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        CounterCondition condition = new CounterCondition(3);
        List childNodes = null;
        Node initial = CreationPatternFactory.getInstance().createLoopPattern("while", (ConditionalExpression)condition, true, childNodes, (Scope)process);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        execution.runStepByStep();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testWhileWithOneUnderActivityPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        CounterCondition condition = new CounterCondition(3);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createLoopPattern("while", (ConditionalExpression)condition, true, childNodes, (Scope)process);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testWhileWithNodeAroundPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        CounterCondition condition = new CounterCondition(3);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("second", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("third", EmptyBehaviourImpl.class, null));
        Node initial = process.createNode("start", EmptyBehaviourImpl.class, null);
        Node while_ = CreationPatternFactory.getInstance().createLoopPattern("while", (ConditionalExpression)condition, true, childNodes, (Scope)process);
        Node end = process.createNode("end", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, while_);
        process.linkedBrotherNodes(while_, end);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_start", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testWhileWithSequenceInsideAndWithNodeAroundPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("WhileProcess"), null);
        CounterCondition condition = new CounterCondition(3);
        ArrayList<Node> childNodesSeq = new ArrayList<Node>();
        childNodesSeq.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodesSeq.add(process.createNode("second", EmptyBehaviourImpl.class, null));
        childNodesSeq.add(process.createNode("third", EmptyBehaviourImpl.class, null));
        Node sequence = CreationPatternFactory.getInstance().createSequencePattern("sequence", childNodesSeq, (Scope)process);
        ArrayList<Node> childNodesWhile = new ArrayList<Node>();
        childNodesWhile.add(sequence);
        Node initial = process.createNode("start", EmptyBehaviourImpl.class, null);
        Node while_ = CreationPatternFactory.getInstance().createLoopPattern("while", (ConditionalExpression)condition, true, childNodesWhile, (Scope)process);
        Node end = process.createNode("end", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, while_);
        process.linkedBrotherNodes(while_, end);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_start", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_sequence", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_sequence", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_sequence", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_sequence", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_sequence", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_second", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_third", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_sequence", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_while", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    public class CounterCondition
    extends AbstractExpressionImpl<String, Boolean>
    implements ConditionalExpression<String> {
        public int counter = 0;
        public int max = 0;

        public CounterCondition(int max) {
            this.max = max;
        }

        public Boolean evaluate(Scope scope) throws CoreException {
            boolean res = true;
            if (this.counter == this.max) {
                res = false;
            }
            ++this.counter;
            return res;
        }

        public void setLog(Logger logger) {
        }

        public String getContent() {
            return null;
        }

        public void setContent(String content) {
        }

        public Expression<String, Boolean> copypaste() {
            return null;
        }
    }
}

