/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.LongExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ThrowBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.WaitBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.fault.FaultImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class ScopePatternTest {
    @Test
    public void testScopePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Node scopeNode = CreationPatternFactory.getInstance().createScopePattern("scope", (Scope)process);
        Scope scope = (Scope)scopeNode.getComponent().getFcInterface("service");
        Node initialNode = scope.createNode("start", EmptyBehaviourImpl.class, null);
        scope.setInitialNode(initialNode);
        process.setInitialNode(scopeNode);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        junit.framework.Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        junit.framework.Assert.assertEquals((String)"scope", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testEmptyScopePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Node scopeNode = CreationPatternFactory.getInstance().createScopePattern("scope", (Scope)process);
        process.setInitialNode(scopeNode);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        junit.framework.Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        junit.framework.Assert.assertEquals((String)"scope", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testScopeInSequencePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Node scopeNode = CreationPatternFactory.getInstance().createScopePattern("scopeInSequence_c", (Scope)process);
        Scope scope = (Scope)scopeNode.getComponent().getFcInterface("service");
        Node startNode = scope.createNode("startInScope", EmptyBehaviourImpl.class, null);
        scope.setInitialNode(startNode);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("a", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("b", EmptyBehaviourImpl.class, null));
        childNodes.add(scopeNode);
        childNodes.add(process.createNode("d", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createSequencePattern("seq", childNodes, (Scope)process);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        junit.framework.Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        junit.framework.Assert.assertEquals((String)"node_supporting_seq", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testScopeInScopePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Node scopeNode = CreationPatternFactory.getInstance().createScopePattern("scope", (Scope)process);
        Scope scope = (Scope)scopeNode.getComponent().getFcInterface("service");
        Node initialNode = CreationPatternFactory.getInstance().createScopePattern("scopeInScope", scope);
        scope.setInitialNode(initialNode);
        process.setInitialNode(scopeNode);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        junit.framework.Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        junit.framework.Assert.assertEquals((String)"scope", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testScopeWithFaultPattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeWithFaultProcess"), null);
        Node scopeNode = CreationPatternFactory.getInstance().createScopePattern("scopeWithFault", (Scope)process);
        Scope scope = (Scope)scopeNode.getComponent().getFcInterface("service");
        Node exceptionScope = CreationPatternFactory.getInstance().createScopePattern("exceptionScope", scope);
        Scope catchScope = (Scope)exceptionScope.getComponent().getFcInterface("service");
        HashMap<String, CoreException> context = new HashMap<String, CoreException>();
        context.put("exception", new MyOtherBusinessException("Error in my other business fault"));
        Node initialCatchNode = catchScope.createNode("startInCatch", ThrowBehaviourImpl.class, context);
        catchScope.setInitialNode(initialCatchNode);
        HashMap<FaultImpl, Scope> catchs = new HashMap<FaultImpl, Scope>();
        FaultImpl myFault = new FaultImpl();
        myFault.setFaultName(new QName(MyBusinessException.class.getName()));
        myFault.setFaultHandler((FaultHandler)new FaultMatcherImpl());
        catchs.put(myFault, catchScope);
        scope.setExceptions(catchs);
        context = new HashMap();
        context.put("exception", new MyBusinessException("Error in my business fault"));
        Node initialNode = scope.createNode("start", ThrowBehaviourImpl.class, context);
        scope.setInitialNode(initialNode);
        process.setInitialNode(scopeNode);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        try {
            process.run();
            junit.framework.Assert.fail();
        }
        catch (MyOtherBusinessException e) {
            junit.framework.Assert.assertEquals((String)"Error in my other business fault", (String)e.getMessage());
        }
        junit.framework.Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        junit.framework.Assert.assertEquals((String)"scopeWithFault", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testProcessWithFaultPattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeWithFaultProcess"), null);
        Node exceptionScope = CreationPatternFactory.getInstance().createScopePattern("exceptionScope", (Scope)process);
        Scope catchScope = (Scope)exceptionScope.getComponent().getFcInterface("service");
        HashMap<String, MyOtherBusinessException> context = new HashMap<String, MyOtherBusinessException>();
        context.put("exception", new MyOtherBusinessException("Error in my other business fault"));
        Node initialCatchNode = catchScope.createNode("startInCatch", ThrowBehaviourImpl.class, context);
        catchScope.setInitialNode(initialCatchNode);
        HashMap<FaultImpl, Scope> catchs = new HashMap<FaultImpl, Scope>();
        FaultImpl myFault = new FaultImpl();
        myFault.setFaultName(new QName(MyBusinessException.class.getName()));
        myFault.setFaultHandler((FaultHandler)new FaultMatcherImpl());
        catchs.put(myFault, catchScope);
        process.setExceptions(catchs);
        context = new HashMap();
        context.put("exception", new MyOtherBusinessException("Error in my other business fault"));
        Node initialNode = process.createNode("start", ThrowBehaviourImpl.class, context);
        process.setInitialNode(initialNode);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        try {
            process.run();
            junit.framework.Assert.fail();
        }
        catch (MyOtherBusinessException e) {
            junit.framework.Assert.assertEquals((String)"Error in my other business fault", (String)e.getMessage());
        }
        junit.framework.Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
    }

    @Test
    public void testWaitScopePattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Node scopeNode = CreationPatternFactory.getInstance().createScopePattern("scope", (Scope)process);
        Scope scope = (Scope)scopeNode.getComponent().getFcInterface("service");
        HashMap<String, LongExpressionImpl> context = new HashMap<String, LongExpressionImpl>();
        context.put("time", new LongExpressionImpl(new Long(5000L)));
        Node waitNode = scope.createNode("wait", WaitBehaviourImpl.class, context);
        scope.setInitialNode(waitNode);
        process.setInitialNode(scopeNode);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        long start = System.currentTimeMillis();
        process.run();
        long time = System.currentTimeMillis() - start;
        long timeout = 10000L;
        while (process.getState() != Process.State.PROCESS_ENDED && time < timeout) {
            Thread.sleep(200L);
            time = System.currentTimeMillis() - start;
        }
        Assert.assertTrue((String)("Timed out " + time + " (" + process.getState() + ")"), (time < timeout ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertTrue((String)"Did not wait", (time > 5000L ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((String)"scope", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    public class LongExpressionImpl
    implements LongExpression<String> {
        private Long l = null;

        public LongExpressionImpl(Long l) {
            this.l = l;
        }

        public void setLog(Logger logger) {
        }

        public Long evaluate(Scope scope) throws CoreException {
            return this.l;
        }

        public String getContent() {
            return null;
        }

        public void setContent(String content) {
        }

        public Expression<String, Long> copypaste() {
            return null;
        }
    }

    public class MyOtherBusinessException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public MyOtherBusinessException(String string) {
            super(string);
        }
    }

    public class MyBusinessException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public MyBusinessException(String string) {
            super(string);
        }

        public MyBusinessException() {
        }
    }

    public class FaultMatcherImpl
    implements FaultHandler {
        public boolean match(Scope s, Fault f, Exception e, Scope faultScope) {
            return f.getFaultName().getLocalPart().equals(e.getClass().getName());
        }

        public void setLog(Logger logger) {
        }

        public <Ex extends CoreException> Ex getModelExceptionFromGenericException(Scope scope, Exception e) throws CoreException {
            return null;
        }
    }
}

