/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl;

import com.ebmwebsourcing.easycommons.logger.LogDataFormatter;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;

public class AbstractCoreTest {
    private Core coreUnderTest = null;

    @BeforeClass
    public static void beforeClass() {
        LogManager.getLogManager().getLogger("").setLevel(Level.FINE);
        for (Handler handler : LogManager.getLogManager().getLogger("").getHandlers()) {
            handler.setLevel(Level.FINE);
            handler.setFormatter((Formatter)new LogDataFormatter());
        }
    }

    @Before
    public void before() throws Exception {
        this.coreUnderTest = this.createCoreUnderTest();
    }

    protected Core createCoreUnderTest() {
        return GenericFactory.getInstance().createCore(this.getDefaultEngineConfiguration(), 1, MemoryReceiverImpl.class, 1, SysoutSenderImpl.class, null);
    }

    @After
    public void after() throws Exception {
        assert (this.coreUnderTest != null);
    }

    protected final Core getCoreUnderTest() {
        return this.coreUnderTest;
    }

    protected ConfigurationEngine getDefaultEngineConfiguration() {
        ConfigurationEngineImpl config = new ConfigurationEngineImpl();
        config.setSingleThreadedExecution(false);
        config.setSynchronousRun(true);
        if (!config.getSingleThreadedExecution()) {
            config.setAutoFlushMessageFrequency(Integer.valueOf(500));
        }
        return config;
    }

    protected void checkExecutionEndedProperly(Execution execution) {
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution.getState());
        Assert.assertNull((Object)execution.getException());
        Assert.assertNull((Object)execution.getCurrentTarget());
    }

    protected void checkExecutionEndedAbnormally(Execution execution, Node throwingNode, Exception e) {
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution.getState());
        Assert.assertEquals((Object)e, (Object)execution.getException());
        Assert.assertEquals((Object)throwingNode, (Object)execution.getCurrentTarget());
    }
}

