/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.ExpressionEvaluator;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.impl.AbstractCoreTest;
import com.ebmwebsourcing.easyviper.core.impl.TestExpressionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.WaitBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class ExclusivePatternTest
extends AbstractCoreTest {
    @Test(timeout=10000L)
    public void testExclusiveWithoutChildPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ExclusiveProcess"), null);
        Node initial = CreationPatternFactory.getInstance().createExclusivePattern("exclusive", null, (Scope)process);
        process.setInitialNode(initial);
        Execution execution = core.getEngine().run(process);
        this.checkExecutionEndedProperly(execution);
    }

    @Test(timeout=10000L)
    public void testExclusiveWitOneChildPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore(this.getDefaultEngineConfiguration(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ExclusiveProcess"), null);
        HashMap<Node, Object> childNodes = new HashMap<Node, Object>();
        childNodes.put(process.createNode("first", EmptyBehaviourImpl.class, null), null);
        Node initial = CreationPatternFactory.getInstance().createExclusivePattern("exclusive", childNodes, (Scope)process);
        process.setInitialNode(initial);
        Node finalNode = process.createNode("final", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, finalNode);
        Execution execution = core.getEngine().run(process);
        this.checkExecutionEndedProperly(execution);
    }

    @Test(timeout=30000L)
    public void testExclusiveWithTwoWaitChildren() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore(this.getDefaultEngineConfiguration(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ExclusiveProcess"), null);
        Node beforeExclusive = process.createNode("beforeExclusive", EmptyBehaviourImpl.class, null);
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return "PT5S";
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        HashMap<String, TestExpressionImpl> context = new HashMap<String, TestExpressionImpl>();
        TestExpressionImpl exp1 = new TestExpressionImpl("'PT5S'");
        context.put("time", exp1);
        Node first = process.createNode("first", WaitBehaviourImpl.class, context);
        Node afterFirst = process.createNode("afterFirst", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(first, afterFirst);
        context = new HashMap();
        TestExpressionImpl exp2 = new TestExpressionImpl("'PT10S'");
        context.put("time", exp2);
        Node second = process.createNode("second", WaitBehaviourImpl.class, context);
        Node afterSecond = process.createNode("afterSecond", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(second, afterSecond);
        HashMap<Node, Node> childNodes = new HashMap<Node, Node>();
        childNodes.put(first, afterFirst);
        childNodes.put(second, afterSecond);
        Node exclusive = CreationPatternFactory.getInstance().createExclusivePattern("exclusive", childNodes, (Scope)process);
        Node afterExclusive = process.createNode("afterExclusive", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(beforeExclusive, exclusive);
        process.linkedBrotherNodes(exclusive, afterExclusive);
        process.setInitialNode(beforeExclusive);
        Execution execution = core.getEngine().run(process);
        while (!process.getExecution().getState().equals((Object)Execution.State.ENDED)) {
            Thread.sleep(100L);
        }
        this.checkExecutionEndedProperly(execution);
    }

    @Test(timeout=10000L)
    public void testExclusiveWithWaitAndMessageChildren() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore(this.getDefaultEngineConfiguration(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ExclusiveProcess"), null);
        Node beforeExclusive = process.createNode("beforeExclusive", EmptyBehaviourImpl.class, null);
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return "PT5S";
            }
        });
        process.setExpressionEvaluator(mockExpressionEvaluator);
        HashMap<String, TestExpressionImpl> context = new HashMap<String, TestExpressionImpl>();
        TestExpressionImpl exp = new TestExpressionImpl("'PT5S'");
        context.put("time", exp);
        Node first = process.createNode("first", WaitBehaviourImpl.class, context);
        Node afterFirst = process.createNode("afterFirst", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(first, afterFirst);
        Node second = process.createNode("second", ReceiverBehaviourImpl.class, null);
        Node afterSecond = process.createNode("afterSecond", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(second, afterSecond);
        HashMap<Node, Node> childNodes = new HashMap<Node, Node>();
        childNodes.put(first, afterFirst);
        childNodes.put(second, afterSecond);
        Node exclusive = CreationPatternFactory.getInstance().createExclusivePattern("exclusive", childNodes, (Scope)process);
        Node afterExclusive = process.createNode("afterExclusive", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(beforeExclusive, exclusive);
        process.linkedBrotherNodes(exclusive, afterExclusive);
        process.setInitialNode(beforeExclusive);
        Execution execution = core.getEngine().run(process);
        while (!process.getExecution().getState().equals((Object)Execution.State.ENDED)) {
            Thread.sleep(100L);
        }
        this.checkExecutionEndedProperly(execution);
    }
}

