/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.ExpressionEvaluator;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingMessageAdapter;
import com.ebmwebsourcing.easyviper.core.impl.AbstractCoreTest;
import com.ebmwebsourcing.easyviper.core.impl.TestExpressionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ThrowBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.WaitBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.fault.FaultImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class ScopePatternTest
extends AbstractCoreTest {
    @Test(timeout=10000L)
    public void testScopePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Scope scopeNode = CreationPatternFactory.getInstance().createScopePattern("scope", (Scope)process);
        Scope scope = (Scope)scopeNode.getComponent().getFcInterface("service");
        Node initialNode = scope.createNode("start", EmptyBehaviourImpl.class, null);
        scope.setInitialNode(initialNode);
        process.setInitialNode((Node)scopeNode);
        Execution main = core.getEngine().run(process);
        this.checkExecutionEndedProperly(main);
    }

    @Test(timeout=10000L)
    public void testEmptyScopePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Scope scopeNode = CreationPatternFactory.getInstance().createScopePattern("scope", (Scope)process);
        process.setInitialNode((Node)scopeNode);
        Execution main = core.getEngine().run(process);
        this.checkExecutionEndedProperly(main);
    }

    @Test(timeout=10000L)
    public void testScopeInSequencePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Scope scopeNode = CreationPatternFactory.getInstance().createScopePattern("scopeInSequence_c", (Scope)process);
        Scope scope = (Scope)scopeNode.getComponent().getFcInterface("service");
        Node startNode = scope.createNode("startInScope", EmptyBehaviourImpl.class, null);
        scope.setInitialNode(startNode);
        ArrayList<Object> childNodes = new ArrayList<Object>();
        childNodes.add(process.createNode("a", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("b", EmptyBehaviourImpl.class, null));
        childNodes.add(scopeNode);
        childNodes.add(process.createNode("d", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createSequencePattern("seq", childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution main = core.getEngine().run(process);
        this.checkExecutionEndedProperly(main);
    }

    @Test(timeout=10000L)
    public void testScopeInScopePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Scope scopeNode = CreationPatternFactory.getInstance().createScopePattern("scope", (Scope)process);
        Scope scope = (Scope)scopeNode.getComponent().getFcInterface("service");
        Scope initialNode = CreationPatternFactory.getInstance().createScopePattern("scopeInScope", scope);
        scope.setInitialNode((Node)initialNode);
        process.setInitialNode((Node)scopeNode);
        Execution main = core.getEngine().run(process);
        this.checkExecutionEndedProperly(main);
    }

    @Test
    public void testScopeWithFaultPattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeWithFaultProcess"), null);
        Scope scopeNode = CreationPatternFactory.getInstance().createScopePattern("scopeWithFault", (Scope)process);
        Scope scope = (Scope)scopeNode.getComponent().getFcInterface("service");
        Scope exceptionScope = CreationPatternFactory.getInstance().createScopePattern("exceptionScope", scope);
        Scope catchScope = (Scope)exceptionScope.getComponent().getFcInterface("service");
        HashMap<String, CoreException> context = new HashMap<String, CoreException>();
        MyOtherBusinessException businessException = new MyOtherBusinessException("Error in my other business fault");
        context.put("exception", businessException);
        Node throwNode = catchScope.createNode("startInCatch", ThrowBehaviourImpl.class, context);
        catchScope.setInitialNode(throwNode);
        HashMap catchs = new HashMap();
        FaultImpl myFault = new FaultImpl();
        myFault.setFaultName(new QName(MyBusinessException.class.getName()));
        myFault.setFaultHandler((FaultHandler)new FaultMatcherImpl());
        scope.addException((Fault)myFault, catchScope);
        context = new HashMap();
        context.put("exception", new MyBusinessException("Error in my business fault"));
        Node initialNode = scope.createNode("start", ThrowBehaviourImpl.class, context);
        scope.setInitialNode(initialNode);
        process.setInitialNode((Node)scopeNode);
        Execution main = core.getEngine().run(process);
        this.checkExecutionEndedAbnormally(main, throwNode, (Exception)((Object)businessException));
    }

    @Test(timeout=10000L)
    public void testProcessWithFaultPattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeWithFaultProcess"), null);
        Scope exceptionScope = CreationPatternFactory.getInstance().createScopePattern("exceptionScope", (Scope)process);
        Scope catchScope = (Scope)exceptionScope.getComponent().getFcInterface("service");
        HashMap<String, MyOtherBusinessException> context = new HashMap<String, MyOtherBusinessException>();
        MyOtherBusinessException businessException = new MyOtherBusinessException("Error in my other business fault");
        context.put("exception", businessException);
        Node initialCatchNode = catchScope.createNode("startInCatch", ThrowBehaviourImpl.class, context);
        catchScope.setInitialNode(initialCatchNode);
        HashMap catchs = new HashMap();
        FaultImpl myFault = new FaultImpl();
        myFault.setFaultName(new QName(MyBusinessException.class.getName()));
        myFault.setFaultHandler((FaultHandler)new FaultMatcherImpl());
        process.addException((Fault)myFault, catchScope);
        context = new HashMap();
        context.put("exception", new MyOtherBusinessException("Error in my other business fault"));
        Node initialNode = process.createNode("start", ThrowBehaviourImpl.class, context);
        process.setInitialNode(initialNode);
        Execution main = core.getEngine().run(process);
        this.checkExecutionEndedAbnormally(main, initialNode, (Exception)((Object)businessException));
    }

    @Test(timeout=10000L)
    public void testWaitScopePattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("scopeProcess"), null);
        Scope scopeNode = CreationPatternFactory.getInstance().createScopePattern("scope", (Scope)process);
        Scope scope = (Scope)scopeNode.getComponent().getFcInterface("service");
        HashMap<String, TestExpressionImpl> context = new HashMap<String, TestExpressionImpl>();
        TestExpressionImpl exp = new TestExpressionImpl("'PT5S'");
        context.put("time", exp);
        Node waitNode = scope.createNode("wait", WaitBehaviourImpl.class, context);
        scope.setInitialNode(waitNode);
        process.setInitialNode((Node)scopeNode);
        ExpressionEvaluator mockExpressionEvaluator = (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class, (Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return "PT5S";
            }
        });
        scope.setExpressionEvaluator(mockExpressionEvaluator);
        long start = System.currentTimeMillis();
        Execution main = core.getEngine().run(process);
        long time = System.currentTimeMillis() - start;
        Assert.assertTrue((String)"Did not wait", (time > 5000L ? 1 : 0) != 0);
        this.checkExecutionEndedProperly(main);
    }

    public class MyOtherBusinessException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public MyOtherBusinessException(String string) {
            super(string);
        }
    }

    public class MyBusinessException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public MyBusinessException(String string) {
            super(string);
        }

        public MyBusinessException() {
        }
    }

    public class FaultMatcherImpl
    implements FaultHandler {
        public boolean match(Execution execution, Fault f, CoreException e, Scope faultScope) {
            return f.getFaultName().getLocalPart().equals(e.getClass().getName());
        }

        public void setLog(Logger logger) {
        }

        public void assignExceptionVariable(Execution execution, CoreException exception, Variable variable) throws CoreException {
        }

        public <Ex extends CoreException> Ex getBPELExceptionFromGenericException(Scope scope, CoreException e, BindingMessageAdapter.Direction direction, boolean isBindingStyleRpc) throws CoreException {
            return null;
        }
    }
}

