/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.environment.test.util;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Operation;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;
import com.ebmwebsourcing.easyviper.environment.test.env.impl.OperationImpl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.namespace.QName;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class MockServiceBuilder {
    public static Operation buildOperation(String operationName, Service service, File requestXmlFile, QName requestMessageName, File responseXmlFile, QName responseMessageName, File faultXmlFile, QName faultMessageName, Class<? extends ExternalMessage> clazz) throws CoreException {
        OperationImpl operation = new OperationImpl(operationName, responseXmlFile == null ? "in-only" : "in-out", service);
        ExternalMessage in = MockServiceBuilder.buildMessage(service.getName(), service.getProviderEndpoint().getName(), requestXmlFile, requestMessageName, clazz, operationName);
        ExternalMessage out = null;
        if (responseXmlFile != null) {
            out = MockServiceBuilder.buildMessage(service.getName(), service.getProviderEndpoint().getName(), responseXmlFile, responseMessageName, clazz, operationName);
        }
        ExternalMessage fault = null;
        if (faultXmlFile != null) {
            fault = MockServiceBuilder.buildMessage(service.getName(), service.getProviderEndpoint().getName(), faultXmlFile, faultMessageName, clazz, operationName);
        }
        operation.addMessageExchangeInstances(in, out, fault);
        return operation;
    }

    public static void addMessageExchangeInstances2Operation(Operation op, File requestXmlFile, QName requestMessageName, File responseXmlFile, QName responseMessageName, File faultXmlFile, QName faultMessageName, Class<? extends ExternalMessage> clazz) throws CoreException {
        ExternalMessage in = MockServiceBuilder.buildMessage(op.getService().getName(), op.getService().getProviderEndpoint().getName(), requestXmlFile, requestMessageName, clazz, op.getName());
        ExternalMessage out = null;
        if (responseXmlFile != null) {
            out = MockServiceBuilder.buildMessage(op.getService().getName(), op.getService().getProviderEndpoint().getName(), responseXmlFile, responseMessageName, clazz, op.getName());
        }
        ExternalMessage fault = null;
        if (faultXmlFile != null) {
            fault = MockServiceBuilder.buildMessage(op.getService().getName(), op.getService().getProviderEndpoint().getName(), faultXmlFile, faultMessageName, clazz, op.getName());
        }
        op.addMessageExchangeInstances(in, out, fault);
    }

    public static ExternalMessage buildMessage(QName serviceName, String endpointName, File xmlFile, QName messageName, Class<? extends ExternalMessage> clazz, String operationName) throws CoreException {
        ExternalMessage msg = null;
        try {
            Constructor<?> c = clazz.getConstructors()[0];
            msg = (ExternalMessage)c.newInstance(new Object[0]);
            msg.setService(serviceName);
            msg.setEndpoint(endpointName);
            msg.setOperationName(operationName);
            msg.setContent((Object)MockServiceBuilder.buildContent(xmlFile));
        }
        catch (JDOMException e) {
            throw new CoreException((Throwable)e);
        }
        catch (IOException e) {
            throw new CoreException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new CoreException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CoreException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CoreException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new CoreException((Throwable)e);
        }
        return msg;
    }

    public static Element buildContent(File xmlFile) throws JDOMException, IOException {
        SAXBuilder parser = new SAXBuilder();
        Element res = null;
        if (xmlFile != null && xmlFile.exists()) {
            Document doc = parser.build(xmlFile);
            res = doc.getRootElement();
        }
        return res;
    }
}

