/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Operation;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;
import com.ebmwebsourcing.easyviper.environment.test.env.api.TestPartner;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public abstract class AbstractServiceImpl
implements Service {
    private static Logger log = Logger.getLogger(AbstractServiceImpl.class.getName());
    private QName name;
    private QName interfaceName;
    private TestPartner providerEndpoint;
    private List<Operation> operations = new ArrayList<Operation>();

    public AbstractServiceImpl(TestPartner providerEndpoint) {
        this.providerEndpoint = providerEndpoint;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public void setName(QName name) {
        this.name = name;
    }

    @Override
    public void addOperation(Operation op) {
        this.operations.add(op);
    }

    @Override
    public List<Operation> getOperations() {
        return this.operations;
    }

    @Override
    public synchronized Message execute(Message msg, String invokedOperation) throws CoreException {
        Message res = null;
        Operation foundOperation = null;
        for (Operation operation : this.operations) {
            if (!invokedOperation.equals(operation.getName())) continue;
            foundOperation = operation;
        }
        if (foundOperation == null) {
            log.severe("operation " + invokedOperation + " with message " + msg.getBody().getPayload() + " not found on service " + this.getName());
            throw new RuntimeException("operation " + invokedOperation + " with message:\n " + msg + "\n not found on service " + this.getName());
        }
        log.finest("Execution of operation " + foundOperation.getName() + " on service " + this.getName());
        res = foundOperation.execute(msg);
        return res;
    }

    @Override
    public TestPartner getTestPartner() {
        return this.providerEndpoint;
    }

    @Override
    public void setTestPartner(TestPartner pep) {
        this.providerEndpoint = pep;
    }

    @Override
    public QName getInterfaceName() {
        return this.interfaceName;
    }

    @Override
    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }
}

