/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.StringExpression;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.LoggerBehaviour;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl.EchoBehaviourImpl;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

@Scope(value="COMPOSITE")
@Service(value={LoggerBehaviour.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class LoggerBehaviourImpl
extends EchoBehaviourImpl
implements LoggerBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(LoggerBehaviourImpl.class.getName());
    @Reference(name="node", required=false)
    protected Node node;
    private LoggerBehaviour.LEVEL level;

    @Override
    public LoggerBehaviour.LEVEL getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(LoggerBehaviour.LEVEL level) {
        this.level = level;
    }

    @Override
    public void severe(String msg) {
        this.log.severe("[BPEL] " + Calendar.getInstance().getTime().toString() + " " + msg);
    }

    @Override
    public void warning(String msg) {
        this.log.warning("[BPEL]  " + Calendar.getInstance().getTime().toString() + " " + msg);
    }

    @Override
    public void info(String msg) {
        this.log.info("[BPEL] " + Calendar.getInstance().getTime().toString() + " " + msg);
    }

    @Override
    public void debug(String msg) {
        this.log.info("[BPEL] " + Calendar.getInstance().getTime().toString() + " " + msg);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String toString() {
        return "LoggerActivity";
    }

    @Override
    public Map<String, Object> getInitializationContext() throws SCAException {
        super.getInitializationContext();
        this.context.put("message", this.getMessage());
        this.context.put("level", this.getLevel());
        return this.context;
    }

    @Override
    public void setInitializationContext(Map<String, Object> context) throws SCAException {
        this.context.put("message", context.get("message"));
        this.context.put("level", context.get("level"));
        this.setMessage((StringExpression)context.get("message"));
        this.setLevel((LoggerBehaviour.LEVEL)((Object)context.get("level")));
    }

    @Override
    protected void executeOnInactive() throws CoreException {
        String msg = (String)this.getMessage().evaluate(this.node.getExecution().getParentScope());
        if (this.level == null) {
            this.severe("Level is null !" + msg);
        } else if (this.level.equals((Object)LoggerBehaviour.LEVEL.SEVERE)) {
            this.severe(msg);
        } else if (this.level.equals((Object)LoggerBehaviour.LEVEL.WARNING)) {
            this.warning(msg);
        } else if (this.level.equals((Object)LoggerBehaviour.LEVEL.INFO)) {
            this.info(msg);
        } else if (this.level.equals((Object)LoggerBehaviour.LEVEL.DEBUG)) {
            this.debug(msg);
        }
    }
}

