/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.extended.service.notification.test;

import com.ebmwebsourcing.easyviper.core.api.engine.PartnerEvaluator;
import javax.xml.namespace.QName;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class TestPartnerEvaluatorImpl
implements PartnerEvaluator {
    private static final String generateLogicalAddress(QName serviceName, String endpointName) {
        String address = "esb://";
        address = address + serviceName.getNamespaceURI();
        address = address + "::" + serviceName.getLocalPart();
        address = address + "@" + endpointName;
        return address;
    }

    private static final boolean isLogicalAddress(String address) {
        return address.startsWith("esb://") && address.contains("@") && address.contains("::");
    }

    public Element createEmptyElement() {
        return new Element("service-ref", Namespace.getNamespace((String)"http://docs.oasis-open.org/wstest/2.0/serviceref"));
    }

    public Element createElement(QName serviceName, String endpointName) {
        Element serviceRefElement = this.createEmptyElement();
        Element eprElement = new Element("EndpointReference", Namespace.getNamespace((String)"http://www.w3.org/2005/08/addressing"));
        Element wsaElement = new Element("Address", Namespace.getNamespace((String)"http://www.w3.org/2005/08/addressing"));
        wsaElement.addContent(TestPartnerEvaluatorImpl.generateLogicalAddress(serviceName, endpointName));
        eprElement.addContent((Content)wsaElement);
        serviceRefElement.addContent((Content)eprElement);
        return serviceRefElement;
    }

    private static final boolean isServiceRefElement(Element element) {
        return "http://docs.oasis-open.org/wstest/2.0/serviceref".equals(element.getNamespaceURI()) && "service-ref".equals(element.getName());
    }

    public String getAddress(Element element) {
        if (element.getChildren().isEmpty()) {
            return null;
        }
        Element eprElement = (Element)element.getChildren().get(0);
        Element wsaElement = eprElement.getChild("Address", Namespace.getNamespace((String)"http://www.w3.org/2005/08/addressing"));
        if (wsaElement == null) {
            return null;
        }
        return wsaElement.getText().trim();
    }

    public QName getServiceName(Element element) {
        String address = this.getAddress(element);
        if (address == null) {
            return null;
        }
        assert (TestPartnerEvaluatorImpl.isLogicalAddress(address));
        return TestPartnerEvaluatorImpl.getServiceNameFromAddress(address);
    }

    public static QName getServiceNameFromAddress(String address) {
        address = address.toString().replace("esb://", "");
        String serviceNamespace = address.substring(0, address.indexOf("::"));
        String serviceLocalPart = address.substring(address.indexOf("::") + "::".length(), address.indexOf("@"));
        return new QName(serviceNamespace, serviceLocalPart);
    }

    public String getEndpointName(Element element) {
        String address = this.getAddress(element);
        if (address == null) {
            return null;
        }
        assert (TestPartnerEvaluatorImpl.isLogicalAddress(address));
        return TestPartnerEvaluatorImpl.getEndpointNameFromAddress(address);
    }

    public static String getEndpointNameFromAddress(String address) {
        return address;
    }

    public void setEndpointName(Element element, String newEndpoint) {
        if (element != null) {
            String address = element.getText().trim();
            String oldEndpoint = TestPartnerEvaluatorImpl.getEndpointNameFromAddress(address);
            address = address.replace(oldEndpoint, newEndpoint);
            element.setText(address);
        }
    }
}

