/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.extended.service.notification.impl.util;

import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.MessageContentExpression;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class NotifMessageContentAnalyzer {
    public static HashSet<Process> extractInvolvedProcesses(List<MessageContentExpression> contentList, Engine engine) {
        HashSet<Process> involvedProcesses = new HashSet<Process>();
        List<String> processIdentifiers = NotifMessageContentAnalyzer.extractProcessIdentifiers(contentList);
        if (processIdentifiers.size() == 0) {
            return new HashSet<Process>(engine.getProcessInstanceRegistry().getProcessInstances());
        }
        for (String processIdentifier : processIdentifiers) {
            involvedProcesses.addAll(NotifMessageContentAnalyzer.extractFromServiceEndpoint(processIdentifier, engine));
            involvedProcesses.addAll(NotifMessageContentAnalyzer.extractFromProcessDefinition(processIdentifier, engine));
            Process p = NotifMessageContentAnalyzer.extractFromProcessName(processIdentifier, engine);
            if (p == null) continue;
            involvedProcesses.add(p);
        }
        return involvedProcesses;
    }

    private static Process extractFromProcessName(String processIdentifier, Engine engine) {
        if (processIdentifier != null && processIdentifier.contains("}") && processIdentifier.contains("_")) {
            return engine.findProcessFromName(processIdentifier);
        }
        return null;
    }

    private static Collection<? extends Process> extractFromProcessDefinition(String processIdentifier, Engine engine) {
        ArrayList<Process> involvedProcesses = new ArrayList<Process>();
        if (processIdentifier != null && processIdentifier.contains("}")) {
            String[] split1 = processIdentifier.split("}");
            String namespace = null;
            String localPart = null;
            if (split1.length == 2) {
                namespace = split1[0].substring(1);
                localPart = split1[1];
                for (Process p : engine.getProcessInstanceRegistry().getProcessInstances()) {
                    if (!p.getName().contains("{" + namespace + "}" + localPart)) continue;
                    involvedProcesses.add(p);
                }
            }
        }
        return involvedProcesses;
    }

    private static Collection<? extends Process> extractFromServiceEndpoint(String processIdentifier, Engine engine) {
        List involvedProcesses = new ArrayList();
        if (processIdentifier != null && processIdentifier.contains("}") && processIdentifier.contains("::")) {
            QName service = NotifMessageContentAnalyzer.findService(processIdentifier);
            String endpoint = NotifMessageContentAnalyzer.findEndpoint(processIdentifier);
            ProcessKeyImpl key = null;
            key = service == null && endpoint != null ? new ProcessKeyImpl(new QName(endpoint), null, null) : new ProcessKeyImpl(null, service, endpoint);
            involvedProcesses = engine.getProcessInstanceRegistry().getProcessInstances((ProcessKey)key);
        }
        return involvedProcesses;
    }

    private static List<String> extractProcessIdentifiers(List<MessageContentExpression> contentList) {
        ArrayList<String> processIdentifiers = new ArrayList<String>();
        if (contentList != null && contentList.size() > 0) {
            for (MessageContentExpression expr : contentList) {
                Document dom;
                try {
                    dom = Wsnb4ServUtils.getWsnbWriter().writeMessageContentExpressionAsDOM(expr);
                }
                catch (WsnbException e) {
                    return processIdentifiers;
                }
                NodeList messageContent = dom.getFirstChild().getOwnerDocument().getElementsByTagNameNS("http://docs.oasis-open.org/wsn/b-2", "MessageContent");
                if (messageContent == null || messageContent.getLength() <= 0) continue;
                NodeList notifContent = messageContent.item(0).getChildNodes();
                NodeList params = null;
                for (int i = 0; i < notifContent.getLength(); ++i) {
                    if (notifContent.item(i).getLocalName() != null && notifContent.item(i).getLocalName().equals("NotifyContent")) {
                        params = notifContent.item(i).getChildNodes();
                    }
                    if (params == null) continue;
                    for (int j = 0; j < params.getLength(); ++j) {
                        if (params.item(j).getLocalName() == null || !params.item(j).getLocalName().equals("params")) continue;
                        NodeList param = params.item(j).getChildNodes();
                        for (int k = 0; k < param.getLength(); ++k) {
                            NodeList paramValue = param.item(k).getChildNodes();
                            for (int l = 0; l < paramValue.getLength(); ++l) {
                                if (paramValue.item(l).getNodeValue() == null) continue;
                                processIdentifiers.add(paramValue.item(l).getNodeValue());
                            }
                        }
                    }
                }
            }
        }
        return processIdentifiers;
    }

    private static QName findService(String address) {
        if (!address.startsWith("{")) {
            return null;
        }
        if (address.startsWith("{}::")) {
            return null;
        }
        QName res = null;
        String[] split1 = address.split("::");
        if (split1.length > 0) {
            res = split1[0].startsWith("{}") ? new QName(split1[0].substring(2)) : QName.valueOf(split1[0]);
        }
        return res;
    }

    private static String findEndpoint(String address) {
        if (!address.startsWith("{")) {
            return null;
        }
        String[] split1 = address.split("::");
        if (split1.length > 1) {
            return split1[1];
        }
        return null;
    }
}

