/**
 * bpmn-di - BPMN graphical layer domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.di.api;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.ILabeledEdge;

/**
 * The source or target definition should only be present if the edge is depicted between a different source or target than the
 * one referenced by the BPMN model element of the BPMNEdge. Only the different source or target is REQUIRED. Both
 * attributes should be present only if both are different. This is the case, for instance, if a Message Flow target is not
 * depicted in the current diagram because it is inside a black box Pool. The Message Flow could then define its target as
 * being the BPMNShape depicting the Pool to connect it to the boundary of that black box Pool.
 * BPMNEdge also contains an optional label of type BPMNLabel that can be nested in the edge when it has a visible
 * textual label with its own bounding box.
 * All BPMNEdge elements are owned directly by a BPMNPlane (that is the root element in a BPMNDiagram). The
 * waypoints of BPMNEdge are always relative to that plane’s origin point and are REQUIRED to be positive coordinates.

 * @author nfleury
 *
 */
public interface IBPMNEdge extends ILabeledEdge{

	IBaseElementBean getModelElement();
	
	/**
	 *  Should be used only for Message Flow. It determines if an envelope decorator should be
	 *	depicted and the kind of envelope to be depicted.
	 * @return
	 */
	MessageVisibleKind getMessageVisibleKind();
}
