/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.common;

import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddErrorEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddImportEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddItemDefinitionEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddMessageEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.DefinitionsHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HasHandlers;

public abstract class AbstractController implements HasHandlers{

	private HandlerManager handlerManager;
	
	public AbstractController() {
		
		this.handlerManager = new HandlerManager(this);
		
	}
	
	@Override
	public void fireEvent(GwtEvent<?> event) {
		
		handlerManager.fireEvent(event);
		
	}
	
	
	public void addDefinitionsHandler(DefinitionsHandler handler){
		
		handlerManager.addHandler(AddImportEvent.TYPE, handler);
		handlerManager.addHandler(AddItemDefinitionEvent.TYPE, handler);
		handlerManager.addHandler(AddMessageEvent.TYPE, handler);
		handlerManager.addHandler(AddErrorEvent.TYPE, handler);
		
	}
	
	
}
