/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.interfaces;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.petalsbpm.definitionseditor.operation.OperationPanel;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.form.Label;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.layout.HorizontalLayout;

public class InterfaceEditPanel extends Panel{

	
	private OperationPanel operationPanel;
	private TextField interfaceNameTxtField;
	private Panel implp;
	
	public InterfaceEditPanel(IInterfaceBean interfaceBean){
		
		this.interfaceNameTxtField = new TextField("Name");
		
		Panel interfaceAttributesPanel = new Panel();
		interfaceAttributesPanel.setBorder(false);
		interfaceAttributesPanel.setLayout(new HorizontalLayout(30));
		
		
		Panel namep = new Panel();
		namep.setBorder(false);
		namep.setLayout(new HorizontalLayout(5));
		namep.add(new Label("Interface Name: "));
		namep.add(interfaceNameTxtField);
		

		this.implp = new Panel();
		implp.setBorder(false);
		implp.setLayout(new HorizontalLayout(5));
		implp.add(new Label("WSDL Implementation: "));
		
		
		
		
		interfaceAttributesPanel.add(namep);
		interfaceAttributesPanel.add(implp);

		
		this.add(interfaceAttributesPanel);
		
		this.operationPanel = new OperationPanel(interfaceBean.getOperations());
		this.operationPanel.setHeight(420);
		this.add(operationPanel);

	}
	
	public Panel getImplp() {
		return implp;
	}
	
	
	public OperationPanel getOperationPanel() {
		return operationPanel;
	}
	
	public TextField getInterfaceNameTxtField() {
		return interfaceNameTxtField;
	}
	
}
