/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.itemdefinition;

import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.DefinitionsHelper;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.form.ComboBox;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;

public class StructureRefComboBox extends ComboBox {
	

	
	private ArrayReader reader;
	
	private Store cbStore;
	
	private List<String> qnames;
	
	public StructureRefComboBox(List<String> qnames) {
		
		this.qnames = qnames;
		
		this.addListener(new ComboBoxListenerAdapter(){
			
			@Override
			public boolean doBeforeShow(Component component) {

				loadStructures();

				return true;
			}
			
		});
	
		initGUI();
	}
	
	private void initGUI(){
		
		RecordDef recordDef 	= new RecordDef(  
                new FieldDef[]{  
                        new StringFieldDef("label")
                }  
        );  
		
		MemoryProxy proxy 		= new MemoryProxy(new Object[0][1]);  
		
		this.reader = new ArrayReader(recordDef);  
		this.cbStore = new Store(proxy, reader);  

		this.setDisplayField("label");  
		this.setStore(cbStore); 
		this.setMode(ComboBox.LOCAL);
		this.setEditable(false);
		this.setForceSelection(true);
		this.setAllowBlank(false);
		
	}
	
	
	private void loadStructures(){
		
		this.cbStore.removeAll();
		
		MemoryProxy proxy 	= new MemoryProxy(getAvailableStructures());
		
		Store storeTemp 	= new Store(proxy,this.reader);
		storeTemp.reload();
		
		this.cbStore.add(storeTemp.getRecords());
		
		
	}
	
	private Object[][] getAvailableStructures(){

		Object[][] objs = new Object[qnames.size()][1];

		for(int i=0;i<qnames.size();i++){
			
			objs[i][0] = qnames.get(i);
			
		}
		
		
		return objs;
	}
	
	
	
}
