/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor.operation;

import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IErrorBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AddElementEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AfterEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.BeforeEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.CellClickEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.EditableGridHandler;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.RemoveElementEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.AbstractController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.error.ErrorRefMultipleComboBox;
import com.ebmwebsourcing.petalsbpm.definitionseditor.message.MessageRefComboBox;
import com.gwtext.client.widgets.grid.GridEditor;

public class OperationController extends AbstractController implements EditableGridHandler{
	
	private OperationPanel panel;
	private List<IMessageBean> msgs;
	private List<IErrorBean> errs;
	private List<String> operationRefs;
	
	public OperationController(OperationPanel panel,List<IMessageBean> msgs,List<IErrorBean> errors,List<String> operationRefs) {
	
		this.panel = panel;
		this.msgs  = msgs;
		this.errs  = errors;
		this.operationRefs = operationRefs;
		
		init();
	}
	
	private void init(){
		
		this.panel.getInMessageColumn().setEditor(new GridEditor(new MessageRefComboBox(msgs)));
		this.panel.getOutMessageColumn().setEditor(new GridEditor(new MessageRefComboBox(msgs)));
		this.panel.getErrorRefColumn().setEditor(new GridEditor(new ErrorRefMultipleComboBox(errs)));
		this.panel.getImplementationRefColumn().setEditor(new GridEditor(new WSDLOperationImplementationRefComboBox(operationRefs)));
	}

	@Override
	public void onAddElement(AddElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAfterEditRecord(AfterEditRecordEvent<?> event) {
		// TODO Auto-generated method stub
		
	}
//	
//	private void validate(List<>){
//		
//	}
	
	@Override
	public void onBeforeEditorRecord(BeforeEditRecordEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveElement(RemoveElementEvent<?> event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onCellClick(CellClickEvent event) {
		// TODO Auto-generated method stub
		
	}
	
}
