/**
 * domain-api - API of Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.choreography;

import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.WithGatewaysBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.WithSequenceFlowsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IEndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IIntermediateCatchEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IIntermediateThrowEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IStartEventBean;

public interface WithChoreographyFlowElementsBean extends WithSequenceFlowsBean, WithGatewaysBean{

    public List<IStartEventBean> getStartEvents();
    public List<IEndEventBean> getEndEvents();
    public List<IIntermediateCatchEventBean> getIntermediateCatchEvents();
    public List<IIntermediateThrowEventBean> getIntermediateThrowEvents();
//    public List<DataObjectBean> getDataObjects();
    public List<IChoreographyTaskBean> getChoreographyTasks();
    public List<ISubChoreographyBean> getSubChoreographies();
    
    public void addStartEvent(IStartEventBean e);
    public void addEndEvent(IEndEventBean e);
    public void addIntermediateCatchEvent(IIntermediateCatchEventBean e);
    public void addIntermediateThrowEvent(IIntermediateThrowEventBean e);
//    public void addDataObject(DataObjectBean e);
    public void addChoreographyTask(IChoreographyTaskBean e);
    public void addSubChoreography(ISubChoreographyBean e);
    
    public void removeStartEvent(IStartEventBean e);
    public void removeEndEvent(IEndEventBean e);
    public void removeIntermediateCatchEvent(IIntermediateCatchEventBean e);
    public void removeIntermediateThrowEvent(IIntermediateThrowEventBean e);
//    public void removeDataObject(DataObjectBean e);
    public void removeChoreographyTask(IChoreographyTaskBean e);
    public void removeSubChoreography(ISubChoreographyBean e);
    
}
