/**
 * domain-api - API of Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.collaboration;

import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.WithFlowNodesBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;

public interface ILaneBean extends IBaseElementBean, WithFlowNodesBean {

    public String getName();

    public void setName(String arg0);

    public com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.activity.ITaskBean getTaskById(
            String arg0);

    public com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.gateway.IGatewayBean getGatewayById(
            String arg0);

    public com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IStartEventBean getStartEventById(
            String arg0);

    public com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IEndEventBean getEndEventById(
            String arg0);

    public com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IIntermediateCatchEventBean getIntermediateCatchEventById(
            String arg0);

    public com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IIntermediateThrowEventBean getIntermediateThrowEventById(
            String arg0);

    public com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.IDataObjectBean getDataObjectById(
            String arg0);

    public List<? extends IFlowElementBean> getFlowNodes();

    public boolean removeFlowElement(
            com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IFlowElementBean arg0);

    public ILaneSetBean getChildLaneSet();

    public void setChildLaneSet(
            ILaneSetBean arg0);

    public void setParentLaneSet(
            ILaneSetBean arg0);

    public ILaneSetBean getParentLaneSet();

    public ILaneBean getParentLane();

    public void setParentLane(ILaneBean arg0);

}
