/**
 * domain-api - API of Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process;

import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.WithFlowElementsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.WithLaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.Constants.ProcessTypes;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.collaboration.ICollaborationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.collaboration.ILaneSetBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.ICallableElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IFlowElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.artifact.WithArtifactsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.foundation.IMainElementBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.activity.ITaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.IDataObjectBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.IIOSpecificationBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.data.IInputOutputBinding;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IEndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IIntermediateCatchEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IIntermediateThrowEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.IStartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.gateway.IGatewayBean;

public interface IProcessBean extends IBaseElementBean, WithFlowElementsBean, WithArtifactsBean,
        WithLaneSetBean, IMainElementBean ,ICallableElementBean{

    public java.lang.String getName();

    public void setName(java.lang.String arg0);

    public ProcessTypes getType();

    public boolean isClosed();
    
    public boolean isExecutable();
    
    public void addLaneSet(ILaneSetBean arg0);

    public void removeLaneSet(ILaneSetBean arg0);

    public ITaskBean getTaskById(java.lang.String arg0);

    public IGatewayBean getGatewayById(java.lang.String arg0);

    public IStartEventBean getStartEventById(java.lang.String arg0);

    public IEndEventBean getEndEventById(java.lang.String arg0);

    public IIntermediateCatchEventBean getIntermediateCatchEventById(java.lang.String arg0);

    public IIntermediateThrowEventBean getIntermediateThrowEventById(java.lang.String arg0);

    public IDataObjectBean getDataObjectById(java.lang.String arg0);

    public List<? extends IFlowElementBean> getFlowNodes();

    public boolean removeFlowElement(IFlowElementBean arg0);

    public void setType(ProcessTypes arg0);

    public void setClosed(boolean arg0);
    
    public void setExecutable(boolean arg0);
    
    public IIOSpecificationBean getIoSpecification();

    public void setIoSpecification(IIOSpecificationBean arg0);

    public ICollaborationBean getDefinitionalCollaboration();
    
    public void setDefinitionalCollaboration(ICollaborationBean c);
    
    public void setIOBindings(List<IInputOutputBinding> ioBinding);
    
    public List<IInputOutputBinding> getIOBindings();
    
    public void addIOBinding(IInputOutputBinding ioBinding);
}
