/**
 * domain-api - API of Domain Objects for BPMN standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service;

import java.util.List;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.WithImplementationRefBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IErrorBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.foundation.IBaseElementBean;

public interface IOperationBean extends IBaseElementBean, WithImplementationRefBean {

    public String getName();

    public void setName(String arg0);

    public void addError(IErrorBean arg0);

    public void removeError(IErrorBean arg0);

    public IMessageBean getMessageIn();

    public void setMessageIn(IMessageBean arg0);

    public IMessageBean getMessageOut();

    public void setMessageOut(IMessageBean arg0);

    public List<IErrorBean> getErrors();

    public void setErrors(List<IErrorBean> arg0);

}
