/**
 * utils - BPMNEditor utils - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.utils.server;



import java.io.*;
import java.util.Enumeration;
import java.util.zip.*;



/**
 * Zip Helper
 * 
 * For handling zip files
 * 
 * @author nfleury
 *
 */
public class ZipHelper {
    
    private static ZipHelper instance;
    
    
    private ZipHelper(){}
    
    
    public static ZipHelper getInstance(){
        
        if (instance==null){
            instance = new ZipHelper();
        }
           
        return instance;
    
    }
    
    
    public File createZipFromFolder(String folderLocation, String zipName) throws Exception{
        try
        {
            File inFolder=new File(folderLocation);
        
            File outFolder=new File(zipName);
        
            ZipOutputStream out = new ZipOutputStream(new 
        
            BufferedOutputStream(new FileOutputStream(outFolder)));
        
            BufferedInputStream in = null;
            
            byte[] data    = new byte[1000];
            
            String files[] = inFolder.list();
            
            for (int i=0; i<files.length; i++)
            {
                in = new BufferedInputStream(new FileInputStream
                 
                 (inFolder.getPath() + "/" + files[i]), 1000);                  
                 
                 out.putNextEntry(new ZipEntry(files[i])); 
                 
                 int count;
                     
                 while((count = in.read(data,0,1000)) != -1){
                 
                     out.write(data, 0, count);
                 
                 }
                 
                 out.closeEntry();
         }
            
             out.flush();
             out.close();
             
             return outFolder;
         
        }
         catch(Exception e){
                 e.printStackTrace();
                 throw new Exception("Couldn't create Zip file:"+zipName+" from folder "+folderLocation);
         } 
    }
    
    
    
    @SuppressWarnings("unchecked")
    public void unzipFile(File file, File unzipDir) throws ZipException, IOException{
    	FileHelper.cleanDirectory(unzipDir);
    	
		ZipFile zf = new ZipFile(file);
		Enumeration<ZipEntry> entries = (Enumeration<ZipEntry>) zf.entries();
		
		while(entries.hasMoreElements()){
			
			ZipEntry ze = entries.nextElement();
			
			InputStream is = zf.getInputStream(ze);
			File f = new File(unzipDir.getAbsolutePath()+File.separator+ze.getName());
			
			FileOutputStream out = new FileOutputStream(f);
			byte buf[]=new byte[1024];
		    int len;
		    while((len=is.read(buf))>0){
		    	out.write(buf,0,len);
		    }
		    out.close();
		    is.close();
		}
	}
    
    
    public boolean isZipFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ZipInputStream zis = new ZipInputStream(fis);
        return (zis.getNextEntry()!=null);
    }
    
}
