/**
 * domain - Domain Objects Implementation for XML Schema Definition Language - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasyschema.domain;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import com.ebmwebsourcing.geasyschema.domain.api.IElement;
import com.ebmwebsourcing.geasyschema.domain.api.ISchema;

public class Schema implements ISchema{
	
	private static final long serialVersionUID = 3921049361395810347L;

	private Set<IElement> elements = new HashSet<IElement>();
	
	private Set<ISchema> imports = new HashSet<ISchema>();
	
	private String tns = "";
	
	public Schema() {
		
	}
	
	@Override
	public void addElement(IElement element) {
		this.elements.add(element);
	}
	
	@Override
	public IElement getElement(String name) {
		for(IElement elem : elements){
			if(elem.getName().equals(name)){
				return elem;
			}
		}
		return null;
	}

	@Override
	public Set<IElement> getElements() {
		return elements;
	}

	@Override
	public String getTargetNamespace() {
		return tns;
	}

	@Override
	public void setTargetNamespace(String namespace) {
		if(tns != null){
			this.tns = namespace;
		} else {
			this.tns = "";
		}
	}
	
	@Override
	public Set<ISchema> getImports() {
		return imports;
	}
	
	@Override
	public void addImport(ISchema schema) {
		if(imports.contains(schema)){
			Iterator<ISchema> it = imports.iterator();
			while(it.hasNext()){
				ISchema existingSchema = it.next();
				if(existingSchema.equals(schema)){
					for(IElement element : schema.getElements()){
						existingSchema.addElement(element);
					}
				}
			}
		} else {
			this.imports.add(schema);
		}
	}

	@Override
	public int hashCode() {
		return tns.hashCode();
	}

	@Override
	public boolean equals(Object o) {
		if(o instanceof ISchema){
			return (tns.equals(((ISchema) o).getTargetNamespace()));
		} else {
			return false;
		}
	}
	
	public IElement findElementInSchemas(String tns, String name){
		IElement result = null;
		
		if(this.tns.equals(tns)){
			result = this.getElement(name);
		}
		
		Iterator<ISchema> it = imports.iterator();
		while(result == null && it.hasNext()){
			result = it.next().findElementInSchemas(tns, name);
		}
		
		return result;
	}

}
