/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasyschema.service.test;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.geasyschema.domain.Element;
import com.ebmwebsourcing.geasyschema.domain.api.IElement;
import com.ebmwebsourcing.geasyschema.domain.api.ISchema;
import com.ebmwebsourcing.geasyschema.service.serverToClient.SchemaParser;
import java.net.URL;
import junit.framework.Assert;
import org.junit.Test;

public class ServiceTest {
    private XmlContextFactory xmlContextFactory = new XmlContextFactory();
    private XmlContext xmlContext = this.xmlContextFactory.newContext();

    @Test
    public void testSchemaParser() throws XmlObjectReadException {
        URL schemaUrl = Thread.currentThread().getContextClassLoader().getResource("schema4test.xsd");
        XmlObjectReader reader = this.xmlContext.createReader();
        Schema schema = (Schema)reader.readDocument(schemaUrl, Schema.class);
        SchemaParser parser = new SchemaParser();
        ISchema ischema = parser.parseSchema(schema);
        Element element0 = new Element("element0.name", "{http://www.w3.org/2001/XMLSchema}string");
        Element element11 = new Element("element11", "{http://www.w3.org/2001/XMLSchema}dateTime");
        com.ebmwebsourcing.geasyschema.domain.Schema import0 = new com.ebmwebsourcing.geasyschema.domain.Schema();
        import0.setTargetNamespace("http://schema4test/circularimport0");
        import0.addElement((IElement)element11);
        Assert.assertNotNull((Object)ischema);
        Assert.assertEquals((String)"http://schema4test", (String)ischema.getTargetNamespace());
        Assert.assertEquals((int)3, (int)ischema.getElements().size());
        Assert.assertTrue((boolean)ischema.getElements().contains(element0));
        Assert.assertTrue((boolean)ischema.getImports().contains(import0));
        Assert.assertEquals((Object)element11, (Object)ischema.findElementInSchemas("http://schema4test/circularimport0", "element11"));
    }
}

