/**
 * service - GeasySchema service - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasyschema.service.clientToServer;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Import;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.geasyschema.domain.api.IElement;
import com.ebmwebsourcing.geasyschema.domain.api.ISchema;

public class SchemaGenerator {

    public Schema generateSchema(ISchema ischema) {
    	
    	XmlContextFactory xmlContextFactory = new XmlContextFactory();
    	XmlContext xmlContext = xmlContextFactory.newContext();
    	XmlObjectFactory xmlObjectFactory = xmlContext.getXmlObjectFactory();
    	Schema schema = xmlObjectFactory.create(Schema.class);

    	for(IElement ielt : ischema.getElements()){
    		Element elt = xmlObjectFactory.create(Element.class);
    		elt.setName(ielt.getName());
    		elt.setType(new QName(ielt.getType()));
    		schema.addElement(elt);
    	}
    	
    	for(ISchema imptSchema : ischema.getImports()){
    		Import impt = xmlObjectFactory.create(Import.class);
    		impt.setNamespace(imptSchema.getTargetNamespace());
    		schema.addImport(impt);
    	}
    	  	
        return schema;
    }
    
}
