/**
 * service - GeasySchema service - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasyschema.service.serverToClient;

import java.util.HashSet;
import java.util.Set;

import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Import;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.geasyschema.domain.api.ISchema;

public class SchemaParser {

    public ISchema parseSchema(Schema schema) {
    	Set<String> importLocations = new HashSet<String>();
    	return this.parseSchema(schema, importLocations);
    }
    
    private ISchema parseSchema(Schema schema, Set<String> importLocations){
    	ISchema result = new com.ebmwebsourcing.geasyschema.domain.Schema();
    	
    	// Namespace
        result.setTargetNamespace(schema.getTargetNamespace());
        
        // Elements
        for(Element elt : schema.getElements()) {
        	String type = null;
        	if(elt.hasType()){
        		type = elt.getType().toString();
        	}
            result.addElement(
            		new com.ebmwebsourcing.geasyschema.domain.Element(elt.getName(), type));
        }
       
        // Imports
        for(ISchema impt : this.parseImports(schema, importLocations)){
        	result.addImport(impt);
        }
        
        return result;
    }
    
    private Set<ISchema> parseImports(Schema schema, Set<String> importLocations){
    	Set<ISchema> imports = new HashSet<ISchema>();
    	
    	for(Import impt : schema.getImports()){
    		if(! importLocations.contains(impt.getSchemaLocation())){
    			Schema imptSchema = (Schema) impt.getXmlObjectAdoptedChildren()[0];
    			importLocations.add(impt.getSchemaLocation());
    			imports.add(parseSchema(imptSchema, importLocations));
    		}
    	}
    	
    	return imports;
    }
    
}
