/**
 * 
 */
package com.ebmwebsourcing.geasysecu.business.domain.extension.to.api;

import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.standard.foundation.BaseElementBean;




/**
 * @author enhan
 *
 */
public class SecuritySetBean extends BaseElementBean implements ISecuritySetBean{
    
    private IConfidentialityRequirementBean confidentiality;
    private IIntegrityRequirementBean integrity;
    private INonRepudiationRequirementBean nonRepudiation;
    private IAvailabilityRequirementBean disponibility;
    private IAuthenticationRequirementBean authentication;
    private IAuthorizationRequirementBean authorization;

    
    
    public SecuritySetBean() {
        confidentiality = new ConfidentialityRequirementBean();
        integrity = new IntegrityRequirementBean();
        nonRepudiation = new NonRepudiationRequirementBean();
        disponibility = new AvailabilityRequirementBean();
        authentication = new AuthenticationRequirementBean();
        authorization = new AuthorizationRequirementBean();

    }

    /* (non-Javadoc)
     * @see com.ebmwebsourcing.geasysecu.business.domain.extension.to.api.ISecuritySetBean#getAuthenticationRequirements()
     */
    @Override
    public IAuthenticationRequirementBean getAuthenticationRequirements() {
        return authentication;
    }

    /* (non-Javadoc)
     * @see com.ebmwebsourcing.geasysecu.business.domain.extension.to.api.ISecuritySetBean#getConfidentialityRequirements()
     */
    @Override
    public IConfidentialityRequirementBean getConfidentialityRequirements() {
        return confidentiality;
    }

    /* (non-Javadoc)
     * @see com.ebmwebsourcing.geasysecu.business.domain.extension.to.api.ISecuritySetBean#getNonRepudiationRequirements()
     */
    @Override
    public INonRepudiationRequirementBean getNonRepudiationRequirements() {
        return nonRepudiation;
    }

    /* (non-Javadoc)
     * @see com.ebmwebsourcing.geasysecu.business.domain.extension.to.api.ISecuritySetBean#getIntegrityRequirements()
     */
    @Override
    public IIntegrityRequirementBean getIntegrityRequirements() {
        return integrity;
    }

    @Override
    public IAuthorizationRequirementBean getAuthorizationRequirements() {
        return authorization;
    }

    @Override
    public void setAuthenticationRequirements(IAuthenticationRequirementBean authentication) {
        if (authentication == null){
            throw new IllegalArgumentException();
        }
        
        this.authentication = authentication;
    }

    @Override
    public void setAuthorizationRequirements(IAuthorizationRequirementBean authorization) {
        if (authorization == null){
            throw new IllegalArgumentException();
        }
        this.authorization = authorization;
    }

    @Override
    public void setIntegrityRequirements(IIntegrityRequirementBean integrity) {
        if (integrity == null){
            throw new IllegalArgumentException();
        }
        this.integrity = integrity;
    }

    @Override
    public void setConfidentialityRequirements(IConfidentialityRequirementBean confidentiality) {
        if (confidentiality == null){
            throw new IllegalArgumentException();
        }
        this.confidentiality = confidentiality;
    }

    @Override
    public void setNonRepudiationRequirements(INonRepudiationRequirementBean nonRepudiation) {
        if (nonRepudiation == null){
            throw new IllegalArgumentException();
        }
        this.nonRepudiation = nonRepudiation;
    }

    @Override
    public IAvailabilityRequirementBean getDisponibilityRequirements() {
        return disponibility;
    }

    @Override
    public void setDisponibilityRequirements(IAvailabilityRequirementBean disponibility) {
        if (disponibility == null){
            throw new IllegalArgumentException();
        }
        this.disponibility = disponibility;
    }


    
}
