package com.ebmwebsourcing.geasysecu.business.domain.policy.to.highlevel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Object which represents a policy file
 * Its content is filled by the server to be used on the GWT Side
 * 
 * @author enhan
 *
 */
/*
 * NOTE : is it a good idea to have such API ?
 * 
 * Goals : manipulates a Policy only as a file
 * Accessing its XML content is possible on the client side.
 * We may add here some connection with the XML mapping.
 * 
 */
public class PolicyFileTO implements Serializable{
    
    /**
     * 
     */
    private static final long serialVersionUID = -6183259512093127927L;
    
    private String fileName;
    private String policyId = "geasysecu-generated-policy";
    private boolean newFile;
    private boolean xmlEdited = false; // to true as soon as the raw XML has been edited directly.  
    private List<String> contentLines;
    private List<IPolicyAspect> aspects;
    
    public PolicyFileTO() {
    	this.aspects = new ArrayList<IPolicyAspect>();
    	this.contentLines = new ArrayList<String>();
	}
    
    public String getFileName() {
        return fileName;
    }
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
    
    public String getContent() {
        String content = "";
        for (String line : contentLines) {
            content+=line+"\n";
        }
        return content;
    }
    
    public boolean isNewFile() {
        return newFile;
    }
    public void setNewFile(boolean newFile) {
        this.newFile = newFile;
    }
    
    public List<String> getContentLines() {
        return contentLines;
    }
    public void setContentLines(List<String> contentLines) {
        this.contentLines = contentLines;
    }
    
    public List<IPolicyAspect> getAspects() {
		return aspects;
	}
	public void setAspects(List<IPolicyAspect> aspects) {
		this.aspects = aspects;
	}
	
	public void addAspect(IPolicyAspect aspect){
		aspects.add(aspect);
	}
	
	public void clearAspects(){
		aspects.clear();
	}

    public boolean isXmlEdited() {
        return xmlEdited;
    }

    public void setXmlEdited(boolean xmlEdited) {
        this.xmlEdited = xmlEdited;
    }

    /**
     * @return the policyId
     */
    public String getPolicyId() {
        return policyId;
    }

    /**
     * @param policyId the policyId to set
     */
    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }
    
    
    
}
