/**
 * geasy-monitoring - A library to perform monitoring - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.client.monitoring.impl;

import com.ebmwebsourcing.geasytools.client.monitoring.api.IHasMonitoring;
import com.ebmwebsourcing.geasytools.client.monitoring.api.IMonitoringConfiguration;
import com.ebmwebsourcing.geasytools.client.monitoring.api.IMonitoringController;
import com.ebmwebsourcing.geasytools.client.monitoring.api.event.IMonitoringNotificationEvent;
import com.ebmwebsourcing.geasytools.client.monitoring.api.rpc.IMonitoringService;
import com.ebmwebsourcing.geasytools.client.monitoring.api.rpc.IMonitoringServiceAsync;
import com.ebmwebsourcing.geasytools.client.monitoring.api.service.MonitoringServiceException;
import com.ebmwebsourcing.geasytools.client.monitoring.impl.event.MonitoringStartEvent;
import com.ebmwebsourcing.geasytools.client.monitoring.impl.event.MonitoringStopEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;

import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.client.event.RemoteEventService;
import de.novanic.eventservice.client.event.RemoteEventServiceFactory;
import de.novanic.eventservice.client.event.domain.Domain;
import de.novanic.eventservice.client.event.domain.DomainFactory;
import de.novanic.eventservice.client.event.listener.RemoteEventListener;

public class MonitoringController implements IMonitoringController,RemoteEventListener{
	
	private IHasMonitoring monitoredSubject;
	private IMonitoringServiceAsync monitoringService;
	private RemoteEventService res;
	private Domain domain;
	
	public MonitoringController(IHasMonitoring monitoredSubject) {
		this.monitoredSubject = monitoredSubject;
		this.monitoringService = GWT.create(IMonitoringService.class);
        this.res = RemoteEventServiceFactory.getInstance().getRemoteEventService();			
        this.domain = DomainFactory.getDomain("Domain_"+DOM.createUniqueId());
	}
	

	
	@Override
	public IHasMonitoring getMonitoredSubject() {
		return monitoredSubject;
	}

	@Override
	public void start(IMonitoringConfiguration configuration) throws MonitoringServiceException {
		
		res.addListener(domain, this);
		
		this.monitoringService.start(domain,configuration, new AsyncCallback<Void>() {
			
			@Override
			public void onSuccess(Void result) {
				
				monitoredSubject.fireEvent(new MonitoringStartEvent());

			}
			
			@Override
			public void onFailure(Throwable caught) {
			
				caught.printStackTrace();
				
			}
		});
		
	}

	@Override
	public void stop() throws MonitoringServiceException {
		
		res.removeListener(domain, this);
		
		this.monitoringService.stop(new AsyncCallback<Void>() {
			
			@Override
			public void onSuccess(Void result) {
				
				monitoredSubject.fireEvent(new MonitoringStopEvent());
				
			}
			
			@Override
			public void onFailure(Throwable caught) {
			
				caught.printStackTrace();
				
			}
		});
		
	}

	@Override
	public void apply(Event anEvent) {
		
		if (anEvent instanceof IMonitoringNotificationEvent){
			
			IMonitoringNotificationEvent e = (IMonitoringNotificationEvent) anEvent;
			
			monitoredSubject.fireEvent((GwtEvent<?>) e);
			
		}
		
	}

}
