/**
 * geasy-monitoring - A library to perform monitoring - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.server.monitoring.impl.service;

import com.ebmwebsourcing.geasytools.client.monitoring.api.IMonitoringConfiguration;
import com.ebmwebsourcing.geasytools.client.monitoring.api.event.IMonitoringNotificationEvent;
import com.ebmwebsourcing.geasytools.client.monitoring.api.rpc.IMonitoringService;
import com.ebmwebsourcing.geasytools.client.monitoring.api.service.IMonitoringEngine;
import com.ebmwebsourcing.geasytools.client.monitoring.api.service.IEngineNotificationManager;
import com.ebmwebsourcing.geasytools.client.monitoring.api.service.MonitoringServiceException;

import de.novanic.eventservice.client.event.domain.Domain;
import de.novanic.eventservice.service.RemoteEventServiceServlet;

public class MonitoringServlet extends RemoteEventServiceServlet implements IMonitoringService{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private IMonitoringEngine engine;
	
	@Override
	public void start(final Domain domain,IMonitoringConfiguration configuration) throws MonitoringServiceException {

		
		try {

			engine  = (IMonitoringEngine) Class.forName(configuration.getMonitoringEngineQname()).newInstance();
			engine.start(configuration.getContext());
		
			engine.setNotificationManager(new IEngineNotificationManager() {
				
				@Override
				public void fireNotification(IMonitoringNotificationEvent event) {
					
					addEvent(domain, event);
					
				}
			});
			
		} catch (InstantiationException e) {
			e.printStackTrace();
			throw new MonitoringServiceException(e.getMessage());		
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			throw new MonitoringServiceException(e.getMessage());
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			throw new MonitoringServiceException(e.getMessage());
		}
		

		
		
		
	}

	@Override
	public void stop() throws MonitoringServiceException {
		engine.stop();
	}

}
