/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.api.draggable;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragProxyHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.google.gwt.event.dom.client.HasMouseDownHandlers;
import com.google.gwt.event.dom.client.HasMouseMoveHandlers;
import com.google.gwt.event.dom.client.HasMouseOutHandlers;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.ui.IsWidget;

public interface IHasDragProxy extends IsWidget,HasMouseOutHandlers,HasMouseDownHandlers,HasMouseMoveHandlers,HasHandlers {

	HashSet<Class<? extends IUIElement>> getDraggedTypes();
	
	IDraggableProxyDefaultHandlers getDraggableProxyDefaultHandlers();
	
	IDraggableElement getDraggableProxy();
	
	void setDraggableProxy(IDraggableElement draggableElement);
	
	IUIPanel getUIPanel();
	
	void setUIPanel(IUIPanel panel);
	
	IHasDragProxyData getData();
	
	Class<? extends IUIElement> getIUIElementType();
	
	void addDragProxyHandler(IDragProxyHandler handler);
	
	String getProxyImgUrl();
	
	/**
	 * Element that was created due to current proxy drop
	 * @return
	 */
	IUIElement getCreatedElement();
	
	void setCreatedElement(IUIElement createdElement);
	
}
