/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.connectable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.geasygraph.api.IGraph;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorEnd;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IMagnet;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IConnectorHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IMouseState;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectableDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.events.ISelectionHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.events.AddIntermediateConnectorPointEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.events.AddWayPointEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.events.ConnectionEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.events.ConnectorHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.events.DisconnectionEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.events.RefreshEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.events.RemoveIntermediateConnectorPointEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.events.RemoveWayPointEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.MouseState;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Point;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.UIElement;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Util;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.DragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.DragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.selectable.SelectableDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.selectable.events.SelectEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.selectable.events.SelectionHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.selectable.events.UnselectEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Widget;

public abstract class Connector extends UIElement implements IConnector{
	
	private IConnectableElement source;
	private IConnectableElement target;
	
	private HandlerManager handlerManager;

	
	private DraggableElementDefaultHandlers draggableDefaultHandlers;
	private SelectableDefaultHandlers selectableDefaultHandler;
	private MouseState mouseState;
	

	
	private IContainer container;
	
	private LinkedHashSet<IConnectorPoint> connectorPoints;
	
	
	public Connector(IUIPanel uipanel,String id) {
		super(uipanel, id);
		this.handlerManager 		  = new HandlerManager(this);
//		this.draggableDefaultHandlers = new DraggableElementDefaultHandlers(this);
//		this.draggableDefaultHandlers.attachDefaultHandlers();
		ConnectorDefaultHandlers cdh = new ConnectorDefaultHandlers(this);
		cdh.attachDefaultHandlers();
		
		
		this.selectableDefaultHandler = new SelectableDefaultHandlers(this);
		this.selectableDefaultHandler.attachDefaultHandlers();
		
		this.mouseState				  = new MouseState();
		

		
		this.connectorPoints		  = new LinkedHashSet<IConnectorPoint>();
		
		
		//container is always uipanel
		this.setContainer(uipanel);
		
		//initWidget(getMainWidget());

		getConnectorStartPoint().setNextPoint(getConnectorEndPoint());
		getConnectorEndPoint().setPreviousPoint(getConnectorStartPoint());
		this.connectorPoints.add(getConnectorStartPoint());
		this.connectorPoints.add(getConnectorEndPoint());
		
		
		
		this.getElement().setId(id);
	}
	
	public Connector(IUIPanel uipanel,String id,IConnectableElement source,IConnectableElement target){
		this(uipanel,id);

		this.connect(source, target);
	}
	
	@Override
	public HandlerRegistration addDoubleClickHandler(DoubleClickHandler handler) {
		return addDomHandler(handler, DoubleClickEvent.getType());
	}
	
	@Override
	public LinkedHashSet<IConnectorPoint> getAllConnectorPoints() {
		return connectorPoints;
	}
	
	
	@Override
	public void addConnectorHandler(IConnectorHandler connectorHandler) {

		handlerManager.addHandler(AddWayPointEvent.TYPE, (ConnectorHandler)connectorHandler);
		handlerManager.addHandler(RemoveWayPointEvent.TYPE, (ConnectorHandler)connectorHandler);
		handlerManager.addHandler(ConnectionEvent.TYPE, (ConnectorHandler)connectorHandler);
		handlerManager.addHandler(DisconnectionEvent.TYPE, (ConnectorHandler)connectorHandler);
		handlerManager.addHandler(RefreshEvent.TYPE, (ConnectorHandler)connectorHandler);
		handlerManager.addHandler(AddIntermediateConnectorPointEvent.TYPE, (ConnectorHandler)connectorHandler);
		handlerManager.addHandler(RemoveIntermediateConnectorPointEvent.TYPE, (ConnectorHandler)connectorHandler);
	}

	@Override
	public void addIntermediateConnectorPoint(IConnectorPoint point,
			IConnectorPoint previousPoint, IConnectorPoint nextPoint) {
		
		this.connectorPoints.add(point);
		point.setPreviousPoint(previousPoint);
		point.setNextPoint(nextPoint);
		previousPoint.setNextPoint(point);
		nextPoint.setPreviousPoint(point);
		this.fireEvent(new AddIntermediateConnectorPointEvent(point, previousPoint, nextPoint));
	}

	@Override
	public void removeIntermediateConnectorPoint(IConnectorPoint point) {
		
		point.getPreviousPoint().setNextPoint(point.getNextPoint());
		point.getNextPoint().setPreviousPoint(point.getPreviousPoint());
		
		this.connectorPoints.remove(point);
		this.fireEvent(new RemoveIntermediateConnectorPointEvent(point));
		this.fireEvent(new RemoveWayPointEvent(point));
		this.refresh();
	}
	
	@Override
	public void connect(IConnectableElement source,
			IConnectableElement target) {
		
		//connect two elements together by finding
		//the closest points
		ClosestsMagnets distance = this.getClosestMagnet(source, target);
		IMagnet targetClosestMagnet = distance.getTargetMagnet();
		IMagnet sourceClosestMagnet = distance.getSourceMagnet();
		
//		System.out.println("target closest magnet:"+targetClosestMagnet.getId());
//		System.out.println("source closest magnet:"+sourceClosestMagnet.getId());
		
		if (sourceClosestMagnet==null){
			throw new IllegalStateException("Couldn't find a closest magnet for source:"+source.getId());
		}
		if (targetClosestMagnet==null){
			throw new IllegalStateException("Couldn't find a closest magnet for target:"+target.getId());
		}
		
		
		sourceClosestMagnet.addConnectorPoint(this.getConnectorStartPoint());
		this.getConnectorStartPoint().setConnectedToMagnet(sourceClosestMagnet);
		source.addOutgoingConnector(this);
		this.setSource(source);
		
	
		
		targetClosestMagnet.addConnectorPoint(this.getConnectorEndPoint());
		this.getConnectorEndPoint().setConnectedToMagnet(targetClosestMagnet);
		target.addIncommingConnector(this);
		this.setTarget(target);

		
		this.refresh();
		source.refreshMagnets();
		target.refreshMagnets();
	}


	@Override
	public void removeFromParent() {
	
		for(IConnectorPoint p:connectorPoints){
			
			if (p instanceof Widget) ((Widget)p).removeFromParent();
			
		}
	}
	
	/**
	 * Returns targets closest magnet to source center
	 * @param source
	 * @param target
	 * @return
	 */
	private ClosestsMagnets getClosestMagnet(IConnectableElement source,IConnectableElement target){
		
		Point sourceCenterPoint = new Point(source.getAbsoluteLeft()+(source.getWidth()/2),source.getAbsoluteTop()+(source.getHeight()/2));
		Point targetCenterPoint = new Point(target.getAbsoluteLeft()+(target.getWidth()/2),target.getAbsoluteTop()+(target.getHeight()/2));
		
		Point sourceIntersectionPoint = Util.getInstance().getClosestIntersectionPointForRectangle(sourceCenterPoint, targetCenterPoint, source.getAbsoluteLeft(), source.getAbsoluteTop(), (int)source.getWidth(), (int)source.getHeight());
		Point targetIntersectionPoint = Util.getInstance().getClosestIntersectionPointForRectangle(targetCenterPoint, sourceCenterPoint, target.getAbsoluteLeft(), target.getAbsoluteTop(), (int)target.getWidth(), (int)target.getHeight());
		
//		System.out.println("Source intersection point:"+sourceIntersectionPoint);
//		System.out.println("Target intersection point:"+targetIntersectionPoint);
		
		//find source closest magnet to sourceCenterPoint
		IMagnet sourceMagnet = null;
		
		ArrayList<MagnetDistance> sourceDistances = new ArrayList<MagnetDistance>();
		
		//calculate all distances between source intersection point and source magnets
		for(IMagnet m :source.getMagnets()){
			
			 sourceDistances.add(new MagnetDistance(m, Util.getInstance().getDistance(sourceIntersectionPoint.getX(), sourceIntersectionPoint.getY(), m.getAbsoluteLeft(), m.getAbsoluteTop())));
			
		}
		
		//get the magnet which has the smallest distance
		MagnetDistance actualSourceMagnetDistance = null;
		for(MagnetDistance md : sourceDistances){
			
			if (sourceMagnet==null){
				
				sourceMagnet = md.magnet;
				actualSourceMagnetDistance = md;
			}
			
			
			
			if (md.getDistance()<actualSourceMagnetDistance.distance){
				
				actualSourceMagnetDistance = md;
				sourceMagnet = md.magnet;
			}
			//System.out.println("Source distance:"+md.getDistance()+" magnet id:"+md.getMagnet().getId()+"["+md.getMagnet().getAbsoluteLeft()+","+md.getMagnet().getAbsoluteTop()+"]");
		}
		
		
		
		//find source closest magnet to targetCenterPoint
		
		IMagnet targetMagnet = null;
		
		ArrayList<MagnetDistance> targetDistances = new ArrayList<MagnetDistance>();
		
		for(IMagnet m : target.getMagnets()){
			
			targetDistances.add(new MagnetDistance(m, Util.getInstance().getDistance(targetIntersectionPoint.getX(), targetIntersectionPoint.getY(), m.getAbsoluteLeft(), m.getAbsoluteTop())));
			
		}
		
		MagnetDistance actualTargetMagnetDistance = null;
		
		for(MagnetDistance md: targetDistances){
			
			if (targetMagnet==null){
				
				targetMagnet = md.magnet;
				actualTargetMagnetDistance = md;
			}
			
			
			
			if (md.getDistance()<actualTargetMagnetDistance.distance){
				
				actualTargetMagnetDistance = md;
				targetMagnet = md.magnet;
			}
			//System.out.println("Target distance:"+md.getDistance()+" magnet id:"+md.getMagnet().getId()+"["+md.getMagnet().getAbsoluteLeft()+","+md.getMagnet().getAbsoluteTop()+"]");
		}
		
		
		ClosestsMagnets cm = new ClosestsMagnets(sourceMagnet, targetMagnet);
		
		
		
		return cm;
	}
	
	
	
	@Override
	public IGraph getGraph() {
		return this.getUIPanel();
	}

	@Override
	public String getId() {
		return this.getElement().getId();
	}

	@Override
	public IConnectableElement getSource() {
		return this.source;
	}

	@Override
	public void setSource(IConnectableElement source) {
		//fire disconnection if there was a source before
		if (this.source!=null && source==null){
			this.fireEvent(new DisconnectionEvent(this.source, null));
		}

		//fire connection event
		if (this.source== null && source !=null) this.fireEvent(new ConnectionEvent(source, target));
		
		this.source = source;
		

	}
	
	@Override
	public void setTarget(IConnectableElement target) {
		
		//fire disconnection if there was a target before
		if (this.target!=null && target==null){
			this.fireEvent(new DisconnectionEvent(null, this.target));
		}
		
		//fire connection event
		if (this.target==null && target!=null) this.fireEvent(new ConnectionEvent(source, target));
		
		this.target = target;
		
	}
	
	@Override
	public IConnectableElement getTarget() {
		return this.target;
	}


	@Override
    public void fireEvent(GwtEvent<?> event) {
    	super.fireEvent(event);
        handlerManager.fireEvent(event);
    }

	@Override
	public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
		return addDomHandler(handler, MouseDownEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
		return addDomHandler(handler, MouseUpEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
		return addDomHandler(handler, MouseOutEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
		return addDomHandler(handler, MouseOverEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
		return addDomHandler(handler, MouseMoveEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
		return addDomHandler(handler, MouseWheelEvent.getType());
	}

	@Override
	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addDomHandler(handler, ClickEvent.getType());
	}
	
	@Override
	public void addSelectionHandler(ISelectionHandler handler) {
		handlerManager.addHandler(SelectEvent.TYPE, (SelectionHandler)handler);
		handlerManager.addHandler(UnselectEvent.TYPE,(SelectionHandler)handler);
	}

	@Override
	public HandlerManager getHandlerManager() {
		return handlerManager;
	}

	@Override
	public ISelectableDefaultHandlers getSelectableDefaultHandlers() {
		return selectableDefaultHandler;
	}


	
	@Override
	public void refresh() {
		
		//Get all connector point
		//if they are attached to a magnet calculate point position
		for(IConnectorPoint point:connectorPoints){
			
			if (point.getConnectedToMagnet()!=null){

				int connectebleMiddleX = (int) (point.getConnectedToMagnet().getConnectableElement().getWidth()/2)+point.getConnectedToMagnet().getConnectableElement().getAbsoluteLeft();
				int connectableMiddleY = (int) (point.getConnectedToMagnet().getConnectableElement().getHeight()/2)+point.getConnectedToMagnet().getConnectableElement().getAbsoluteTop();

//				Point p1 = new Point(point.getConnectedToMagnet().getAbsoluteLeft()+Helper.CONNECTOR_INTERSECTIONPOINT_X_ADJUST, point.getConnectedToMagnet().getAbsoluteTop()+Helper.CONNECTOR_INTERSECTIONPOINT_Y_ADJUST);
				Point p1 = new Point(connectebleMiddleX,connectableMiddleY);
				Point p2 = null;
				
				if (point instanceof IConnectorEnd){
					p2 = new Point(point.getPreviousPoint().getAbsoluteLeft(),point.getPreviousPoint().getAbsoluteTop());
				}else{
					p2 = new Point(point.getNextPoint().getAbsoluteLeft(),point.getNextPoint().getAbsoluteTop());
				}
				
				
				
				Point intersectionPoint = Util.getInstance().getClosestIntersectionPointForRectangle(
						p1,
						p2,
						point.getConnectedToMagnet().getConnectableElement().getAbsoluteLeft(),
						point.getConnectedToMagnet().getConnectableElement().getAbsoluteTop(),
						(int)point.getConnectedToMagnet().getConnectableElement().getWidth(),
						(int)point.getConnectedToMagnet().getConnectableElement().getHeight());
				
				
				
				float x = intersectionPoint.getX()-getUIPanel().getAbsoluteLeft()+getUIPanel().getScrollLeft();
				float y = intersectionPoint.getY()-getUIPanel().getAbsoluteTop()+getUIPanel().getScrollTop();
				point.setRelativeX(x);
				point.setRelativeY(y);
//				System.out.println("connectable x:"+point.getConnectedToMagnet().getConnectableElement().getAbsoluteLeft());
//				System.out.println("point:"+point.getId()+" =>"+intersectionPoint);
				
				
			}
			
		}
		
		this.fireEvent(new RefreshEvent());
	}




	@Override
	public IMouseState getMouseState() {
		return this.mouseState;
	}

	@Override
	public float getRelativeX() {
		return this.getAbsoluteLeft() - this.getContainer().getAbsoluteLeft();
	}

	@Override
	public float getRelativeY() {
		return this.getAbsoluteTop() - this.getContainer().getAbsoluteTop();
	}


	@Override
	public float getWidth() {
		return this.getSEPoint().getX() - this.getNWPoint().getX();
	}

	@Override
	public float getHeight() {
		return this.getSEPoint().getY() - this.getNWPoint().getY();
	}
	@Override
	public void setContainer(IContainer container) {
		this.container = container;
	}

	@Override
	public IContainer getContainer() {
		return this.container;
	}
	
	
	protected Point getNWPoint(){
		
		float minX = -1;
		float minY = -1;
		
		Point nwPoint = new Point(-1, -1); 
		
		for(IConnectorPoint p: this.getAllConnectorPoints()){
			
			if (minX==-1){
				minX = p.getAbsoluteLeft();
				nwPoint = new Point(minX,nwPoint.getY());
			}
			if (minY==-1){
				minY = p.getAbsoluteTop();
				nwPoint = new Point(nwPoint.getX(), minY);
			}
			
			if (p.getAbsoluteLeft()<minX){
				
				minX = p.getAbsoluteLeft();
				nwPoint = new Point(minX,nwPoint.getY());
			}
			
			if (p.getAbsoluteTop()<minY){
				
				minY = p.getAbsoluteTop();
				nwPoint = new Point(nwPoint.getX(),minY);
				
				
			}
			
		}
	
		return nwPoint;
	}
	
	
	protected Point getSEPoint(){
		
		float maxX = -1;
		float maxY = -1;
		
		Point sePoint = new Point(-1, -1); 
		
		for(IConnectorPoint p: this.getAllConnectorPoints()){
			
			if (maxX==-1){
				maxX = p.getAbsoluteLeft();
				sePoint = new Point(maxX,sePoint.getY());
			}
			if (maxY==-1){
				maxY = p.getAbsoluteTop();
				sePoint = new Point(sePoint.getX(),maxY);
			}
			
			if (p.getAbsoluteLeft()>maxX){
				
				maxX = p.getAbsoluteLeft();
				sePoint = new Point(maxX,sePoint.getY());
			}
			
			if (p.getAbsoluteTop()>maxY){
				
				maxY = p.getAbsoluteTop();
				sePoint = new Point(sePoint.getX(),maxY);
				
				
			}
			
		}

		return sePoint;
	}
	

	@Override
	public void setWidth(float width) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void addDragHandler(IDragHandler dragHandler) {
		handlerManager.addHandler(DragStartEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(DragMoveEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(DragStopEvent.TYPE, (DragHandler)dragHandler);
	}

	@Override
	public IDraggableElementDefaultHandlers getDraggableElementDefaultHandlers() {
		return draggableDefaultHandlers;
	}

	@Override
	public HashSet<Class<? extends IUIElement>> getDraggedTypes() {
		
		HashSet<Class<? extends IUIElement>> draggedEl = new HashSet<Class<? extends IUIElement>>();
		
		draggedEl.add(this.getClass());
		
		return draggedEl;
	}

	


	
	@Override
	public abstract int getAbsoluteLeft();
	
	@Override
	public abstract int getAbsoluteTop();

	
	private class ClosestsMagnets {
		
		private IMagnet sourceMagnet;
		private IMagnet targetMagnet;
	 
		
		public ClosestsMagnets(IMagnet sourceMagnet,IMagnet targetMagnet) {
			this.sourceMagnet = sourceMagnet;
			this.targetMagnet = targetMagnet;
	
		}
		
		public IMagnet getSourceMagnet() {
			return sourceMagnet;
		}
		
		public IMagnet getTargetMagnet() {
			return targetMagnet;
		}
		
		
	}
	
	
	private class MagnetDistance {
		
		private IMagnet magnet;
		private double distance;
		
		public MagnetDistance(IMagnet magnet, double d) {
			
			this.magnet 	= magnet;
			this.distance   = d;
		}
		
		public double getDistance() {
			return distance;
		}
		
	}
	

}
