/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.connectable;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorEnd;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorStart;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IMagnet;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDDManager;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDroppableDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DropHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DroppableDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.OutEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.OverEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.Composite;

public abstract class Magnet extends Composite implements IMagnet,DropHandler{
	
	private HandlerManager handlerManager;
	private IConnectableElement connectable;
	private DroppableDefaultHandlers droppableDefaultHandlers;
	
	private IContainer container;
	
	private HashSet<IConnectorPoint> connectorPoints;
	
	public Magnet(IConnectableElement connectable) {
		
		this.handlerManager 	= new HandlerManager(this);
		this.connectable 		= connectable;
		this.connectorPoints 	= new HashSet<IConnectorPoint>();
		
		this.droppableDefaultHandlers = new DroppableDefaultHandlers(this);
		this.addDropHandler(this);
	
		//container is always uipanel
		this.setContainer(connectable.getUIPanel());
	}
	
	
	@Override
	public IContainer getContainer() {
		return this.container;
	}
	
	@Override
	public void setContainer(IContainer container) {
		this.container = container;
	}
	
	@Override
	public IConnectableElement getConnectableElement() {
		return this.connectable;
	}

	@Override
	public void addDropHandler(IDropHandler dropHandler) {
		getHandlerManager().addHandler(OverEvent.TYPE,(DropHandler) dropHandler);
		getHandlerManager().addHandler(OutEvent.TYPE,(DropHandler) dropHandler);
		getHandlerManager().addHandler(DropAcceptedEvent.TYPE, (DropHandler) dropHandler);
		getHandlerManager().addHandler(DropRefusedEvent.TYPE, (DropHandler) dropHandler);
	}

	@Override
	public HashSet<Class<? extends IDraggableElement>> getAcceptedTypes() {
		HashSet<Class<? extends IDraggableElement>> acceptedTypes = new HashSet<Class<? extends IDraggableElement>>();
		
		acceptedTypes.add(IConnectorStart.class);
		acceptedTypes.add(IConnectorEnd.class);
		
		return acceptedTypes;
	}

	@Override
	public IDroppableDefaultHandlers getDroppableDefaultHandlers() {
		return droppableDefaultHandlers;
	}

	
	public HandlerManager getHandlerManager() {
		return handlerManager;
	}


	@Override
	public void fireEvent(GwtEvent<?> event) {
		super.fireEvent(event);
		handlerManager.fireEvent(event);
	}
	
	@Override
	public float getRelativeX() {
		return this.getAbsoluteLeft() - this.getUIPanel().getAbsoluteLeft();
	}

	@Override
	public float getRelativeY() {
		return this.getAbsoluteTop()  - this.getUIPanel().getAbsoluteTop();
	}

	@Override
	public IDDManager getDDManager() {
		return connectable.getUIPanel().getDDManager();
	}

	@Override
	public String getId() {
		return this.getElement().getId();
	}

	@Override
	public IUIPanel getUIPanel() {
		return connectable.getUIPanel();
	}

	@Override
	public void onDropAccepted(IDropAcceptedEvent event) {
		
		if (event.getDraggableElement() instanceof IConnectorPoint){
			
			IConnectorPoint cp = (IConnectorPoint)event.getDraggableElement();
			this.addConnectorPoint(cp);
			cp.setConnectedToMagnet(this);
			

			//add connector to incoming or outgoing 
			
				//outgoing
				if (cp instanceof IConnectorStart){
					
					getConnectableElement().addOutgoingConnector(cp.getConnector());
					
					cp.getConnector().setSource(connectable);
					
				}else if (cp instanceof IConnectorEnd){
					
					getConnectableElement().addIncommingConnector(cp.getConnector());
					
					cp.getConnector().setTarget(connectable);
				}
			
		}
		
	}

	@Override
	public void onDropRefused(IDropRefusedEvent event) {}

	@Override
	public void onOut(IOutEvent event) {
		
		if (connectorPoints.contains(event.getDraggableElement())){

			IConnectorPoint cp = (IConnectorPoint)event.getDraggableElement();
			this.removeConnectorPoint(cp);
			cp.setConnectedToMagnet(null);
			
			
			//remove connector from incoming or outgoing
			if (connectable.getIncommingConnectors().contains(cp.getConnector())){
				connectable.getIncommingConnectors().remove(cp.getConnector());
			}else if (connectable.getOutgoingConnectors().contains(cp.getConnector())){
				connectable.getOutgoingConnectors().remove(cp.getConnector());
			}
			
			if (cp instanceof IConnectorStart){
				
				cp.getConnector().setSource(null);
			
			}else if (cp instanceof IConnectorEnd){
			
				cp.getConnector().setTarget(null);
			
			}
			
			
		}
		

		
		
	}

	@Override
	public void onOver(IOverEvent event) {
		

		
	}
	
	@Override
	public HashSet<IConnectorPoint> getConnectorPoints() {
		return connectorPoints;
	}
	
	
	@Override
	public void addConnectorPoint(IConnectorPoint connectorPoint) {
		this.connectorPoints.add(connectorPoint);
	}
	
	@Override
	public void removeConnectorPoint(IConnectorPoint connectorPoint) {
		this.connectorPoints.remove(connectorPoint);
	}
	


}
