/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.core;

import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IGraphicElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IHasBoundsUpdateHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.IResizableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.INewUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUnselectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.events.PositionChangeEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableProxy;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DropHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.ResizableElementDefaultHandlers;

public class DefaultContainerChildHandler implements DropHandler{
	
	private IContainer container;
	private IUIPanel uiPanel;
	
	public DefaultContainerChildHandler(IContainer container,IUIPanel uipanel) {

		this.container 	= container;
		this.uiPanel 	= uipanel;
	}
	
	@Override
	public void onDropAccepted(IDropAcceptedEvent event) {
		
		IUIElement draggedElement = null;
		
		
		//When removing an element that belongs to actual container => refresh container
		this.uiPanel.addUIPanelHandler(new IUIPanelHandler() {
			
			@Override
			public void onUnSelectUIElement(
					IUnselectedElementsEvent unselectedElementsEvent) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onSelectUIElement(ISelectedElementsEvent selectedElementsEvent) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onResizeRequest(IResizeRequestEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onRemoveUIElement(IRemoveUIElementEvent removeElementEvent) {
				
				if (container instanceof IUIElement){
					if (removeElementEvent.getRemovedElement().getContainer().equals(container)){
						
							IUIElement ec = (IUIElement) container;
							ec.refresh();
					
						
					}
				}
			}
			
			@Override
			public void onNewUIElement(INewUIElementEvent newElementEvent) {
				// TODO Auto-generated method stub
				
			}
		});
		
		
		
		if (event.getDraggableElement() instanceof IUIElement) {
			draggedElement = (IUIElement) event
					.getDraggableElement();

			// first remove draggable from previous Container
			if (draggedElement.getContainer() != null) {

				draggedElement.getContainer().removeChildElement(
						draggedElement);

				
				//refresh
				if (draggedElement.getContainer() instanceof IGraphicElement) {

					IGraphicElement g = (IGraphicElement) draggedElement
							.getContainer();
					g.refresh();

				}
			}
			
			//set child position where we've just dropped it
			draggedElement.setRelativeX(event.getX());
			draggedElement.setRelativeY(event.getY());
			
			// add dragged element to container
			container.addUIElement(draggedElement);
			draggedElement.setContainer(container);
			
			//if draggedElements hasboundupdate notifier fire position update event
			if (draggedElement instanceof IHasBoundsUpdateHandler){
				((IHasBoundsUpdateHandler) draggedElement).fireEvent(new PositionChangeEvent(0, 0, event.getX(), event.getY()));
			}
			
			//if its a connectable refresh magnets
			if (draggedElement instanceof IConnectableElement){
				IConnectableElement c = (IConnectableElement) draggedElement;
				c.refreshMagnets();
			}
			
			//refresh actual container
			if (container instanceof IGraphicElement) {

				IGraphicElement g = (IGraphicElement) container;
				g.refresh();
			}
			
			//if its a resizable
			if(draggedElement instanceof IResizableElement){
				//TODO: refreshing uihandler should be part of IResizableElement
				IResizableElement r = (IResizableElement) draggedElement;
				if (r.getResizableDefaultHandlers() instanceof ResizableElementDefaultHandlers) ((ResizableElementDefaultHandlers)r.getResizableDefaultHandlers()).refreshUIHandlersPositions();
				
			}

		}else if (event.getDraggableElement() instanceof DraggableProxy){
		
			DraggableProxy proxy = (DraggableProxy) event.getDraggableElement();
			
			IHasDragProxy hasdeproxy = proxy.getHasDraggableElementProxy();
			

			if (container.getElementFactory()==null){
				throw new IllegalStateException("Actual container Factory is null, please ensure actual container has an associated element factory");
			}
			
			IUIElement createdElement = container.getElementFactory().getElement(hasdeproxy);
			
			if (createdElement==null){
				throw new IllegalStateException("Couldn't create element from type:"+hasdeproxy.getIUIElementType()+" please ensure container factory has been implemented to create such an element");
			}
			
			//add created element to uipanel only if container is not already the UIPanel
			if (container instanceof IUIPanel==false) uiPanel.addUIElement(createdElement);

			//set child position where we've just dropped it
			createdElement.setRelativeX(event.getX());
			createdElement.setRelativeY(event.getY());
			
			//add drag proxy to container
			container.addUIElement(createdElement);
			createdElement.setContainer(container);
			
			hasdeproxy.setCreatedElement(createdElement);
			
			//if draggedElements hasboundupdate notifier fire position update event
			if (createdElement instanceof IHasBoundsUpdateHandler){
				((IHasBoundsUpdateHandler) createdElement).fireEvent(new PositionChangeEvent(0, 0, event.getX(), event.getY()));
			}
			
			//if its a connectable refresh magnets
			if (createdElement instanceof IConnectableElement){
				IConnectableElement c = (IConnectableElement) createdElement;
				c.refreshMagnets();
			}
			
			if(createdElement instanceof IConnector 
					&& hasdeproxy instanceof IHasMenuDragProxy
					&& container instanceof IConnectableElement) {
				((IConnector)createdElement).connect((IConnectableElement) ((IHasMenuDragProxy)hasdeproxy).getContextualMenuSubject(), (IConnectableElement) container);
			}
			
			if (container instanceof IGraphicElement) {
				IGraphicElement g = (IGraphicElement) container;
				g.refresh();
			}
			
			//if its a resizable
			if(createdElement instanceof IResizableElement){
				//TODO: refreshing uihandler should be part of IResizableElement
				IResizableElement r = (IResizableElement) createdElement;
				if (r.getResizableDefaultHandlers() instanceof ResizableElementDefaultHandlers) ((ResizableElementDefaultHandlers)r.getResizableDefaultHandlers()).refreshUIHandlersPositions();
				
			}
			
		}
		
	}

	@Override
	public void onDropRefused(IDropRefusedEvent event) {
		
		
		//if something have been drop and refused
		//retrieve the parent in order to refresh
		if (event.getDraggableElement() instanceof IUIElement){
			
			IUIElement el = (IUIElement) event.getDraggableElement();
			
			if (el.getContainer() instanceof IUIElement){
				
				IUIElement elContainer = (IUIElement) el.getContainer();
				
				elContainer.refresh();
				
			}
			
		}
		
		
	}

	@Override
	public void onOut(IOutEvent event) {}

	@Override
	public void onOver(IOverEvent event) {}

}
