/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.core;

import java.util.Collection;

import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IRegion;

public class Region<T> implements IRegion{
	
	private IPoint topLeftPoint;
	private IPoint bottomRightPoint;
	
	private T subject;
	
	public Region(IPoint iPoint,IPoint iPoint2) {
		
		Direction direction = Util.getInstance().getDirection((Point)iPoint,(Point)iPoint2);
		
		int width  = (int) Math.abs(iPoint2.getX()-iPoint.getX());
		int height = (int) Math.abs(iPoint2.getY()-iPoint.getY()); 
		
		if (direction==Direction.SE){
			
			this.topLeftPoint 		= iPoint;
			this.bottomRightPoint 	= iPoint2;
		
		}else if (direction == Direction.NW){
			
			this.topLeftPoint		= iPoint2;
			this.bottomRightPoint	= iPoint;
			
		}else if (direction == Direction.NE){
			
			this.topLeftPoint		= new Point(iPoint.getX()-width, iPoint.getY()-height);
			this.bottomRightPoint	= new Point(iPoint2.getX()+width,iPoint2.getY()+height);
		
		}else if (direction == Direction.SW){
			
			this.topLeftPoint		= new Point(iPoint.getX()+width, iPoint.getY()+height);
			this.bottomRightPoint	= new Point(iPoint2.getX()-width,iPoint2.getY()-height);
			
		}else if (direction == Direction.E ){
			
			this.topLeftPoint 		= new Point(iPoint.getX(),iPoint.getY()-width);
			this.bottomRightPoint	= new Point(iPoint2.getX(),iPoint2.getY()+width);
			
		}else if (direction == Direction.W){

			this.topLeftPoint 		= new Point(iPoint2.getX(),iPoint2.getY()-width);
			this.bottomRightPoint	= new Point(iPoint.getX(),iPoint.getY()+width);
			
		}else if (direction == Direction.N){
			
			this.topLeftPoint		= new Point(iPoint2.getX()-height,iPoint2.getY());
			this.bottomRightPoint	= new Point(iPoint.getX()+height,iPoint.getY());
		
		}else if (direction ==Direction.S){
			
			this.topLeftPoint		= new Point(iPoint.getX()-height,iPoint.getY());
			this.bottomRightPoint	= new Point(iPoint2.getX()+height,iPoint2.getY());
			
		}
		
		
		
	}
	
	public Region(IPoint topLeftPoint,IPoint bottomRightPoint,T subject) {
		this(topLeftPoint,bottomRightPoint);
		this.subject			= subject;
		
	}

	public IPoint getBottomRightPoint() {
		return bottomRightPoint;
	}
	
	public IPoint getTopLeftPoint() {
		return topLeftPoint;
	}
	
	
	public T getSubject() {
		return subject;
	}
	
	public boolean contains(IPoint point){
		
		//if topLeftPoint < point < bottomRightPoint
		//then point € Region
		
		if (point.greaterThan(topLeftPoint) && point.smallerThan(bottomRightPoint)){
		
			return true;
		
		}else if (point.greaterThan(bottomRightPoint) && point.smallerThan(topLeftPoint)){
			
			return true;
			
		}
		
		return false;
	}
	
	public boolean containsOneOf(Collection<Point> collection){
		
		for(Point p:collection){
			
			if (this.contains(p)){
				return true;
			}
			
		}
		
		return false;
	}
	
	
	@Override
	public String toString() {
		return "topLeftPoint="+topLeftPoint.toString()+" bottomRightPoint="+bottomRightPoint.toString();
	}

	@Override
	public IPoint getNorthWestPoint() {
		return getTopLeftPoint();
	}

	@Override
	public IPoint getSouthEastPoint() {
		return getBottomRightPoint();
	}

}
