/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.core;

import java.util.ArrayList;

import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;

public class Util {
	
	private static Util instance;

	
	
	private Util(){
		
	}
	
	public static Util getInstance(){
		
		if (instance==null){
			instance = new Util();
		}
		
		return instance;
	}
	
	
	public Point getNWPointFromElements(ArrayList<? extends IUIElement> elements){
		
		//NW point has the smallest y and smallest x
		//beyond every selected element
		int smallestx = elements.get(0).getAbsoluteLeft();
		int smallesty = elements.get(0).getAbsoluteTop();
		
		Point nwPoint = new Point(elements.get(0).getAbsoluteLeft() - elements.get(0).getContainer().getAbsoluteLeft() ,
				elements.get(0).getAbsoluteTop() - elements.get(0).getContainer().getAbsoluteTop());
		
		for(IUIElement s:elements){
			
				if (s.getAbsoluteLeft()<smallestx){
					
					smallestx = s.getAbsoluteLeft();
					
					nwPoint = new Point(s.getAbsoluteLeft()-s.getContainer().getAbsoluteLeft(),
							nwPoint.getY());
					
				}
				
				
				if (s.getAbsoluteTop()<smallesty){
					
					smallesty = s.getAbsoluteTop();	
					
					nwPoint = new Point(nwPoint.getX(),
							s.getAbsoluteTop()-s.getContainer().getAbsoluteTop());
				}
			
			
			
		}
		
		return nwPoint;
		
	}
	
	
	public Point getSEPointFromElements(ArrayList<? extends IUIElement> elements){
		//SE point is the greatest selected element position + width + height
		IUIElement randomS = elements.get(0);
		
		int greatestx = (int) (randomS.getAbsoluteLeft() + randomS.getWidth());
		int greatesty = (int) (randomS.getAbsoluteTop() + randomS.getHeight());
		
		Point sePoint = new Point((randomS.getAbsoluteLeft()+randomS.getWidth())-randomS.getContainer().getAbsoluteLeft(),
				(randomS.getAbsoluteTop()+randomS.getHeight())-randomS.getContainer().getAbsoluteTop());
		
		
		for(IUIElement s:elements){
			
			if ((s.getAbsoluteLeft()+s.getWidth())>greatestx ){
				
				greatestx = (int) (s.getAbsoluteLeft()+s.getWidth());
				
				
				sePoint = new Point((s.getAbsoluteLeft()+s.getWidth())-s.getContainer().getAbsoluteLeft(),
						sePoint.getY());
			}
			
			
			if ((s.getAbsoluteTop()+s.getHeight())>greatesty){
				
				greatesty = (int) (s.getAbsoluteTop()+s.getHeight());

				sePoint = new Point(sePoint.getX(),
						(s.getAbsoluteTop()+s.getHeight())-s.getContainer().getAbsoluteTop());

			}
			
		}
		
		
		
		return sePoint;
	}
	
	

	
	public Point getClosestIntersectionPointForRectangle(Point p1,Point p2,int rx,int ry,int rwidth,int rheight){
		

//		
		LinearFunction fn1 = this.getLinearFunctionFrom2Points(p1, p2);

		///////////////////
		
		
		//Calculate intersection point 
		//for each edge and select the closest one
		ArrayList<Point> points = new ArrayList<Point>();
		
		//calculate top edge intersection
		int y = ry;
		
		LinearFunction fn2 = new LinearFunction(0, y);
		
		Point topItersection =  this.getIntesectionPointFromLinearFn(fn1, fn2);
		
		if (topItersection!=null) points.add(topItersection);
		
		//calculate bottom edge intersection
		y = ry + rheight;
		
		LinearFunction fn3 = new LinearFunction(0, y);
		
		Point bottomIntersection = this.getIntesectionPointFromLinearFn(fn1, fn3);
		
		if (bottomIntersection!=null) points.add(bottomIntersection);
		//calculate left edge intersection
		int x = rx;
		
		Point leftIntersection = new Point(x,fn1.getFx(x));
		if (leftIntersection!=null) points.add(leftIntersection);
		//calculate right edge intersection
		x = rx+rwidth;
		
		Point rightIntersection = new Point(x,fn1.getFx(x));
		
		if (rightIntersection!=null) points.add(rightIntersection); 
		
		//get closest point
		//+1 and -1 are for the cases where we may have some points that are on the extremity of the region
		//otherwise it would exclude some points that should be considered
		Point closestPoint = this.getClosestPoint(p2, points,new Region(new Point(rx-1,ry-1),new Point(rx+rwidth+1,ry+rheight+1)));
		
		
		//should not happend but we never know
		if (closestPoint==null){
		
			closestPoint = p1;
		}
		
		
		return closestPoint;
	}
	;
	
	public Point getClosestPoint(Point p1,ArrayList<Point> points,Region<?> r){
		
		float minDx=-1;
		float minDy=-1;
		
		Point closestPoint = null;
		ArrayList<Point> insideRegionPoints = new ArrayList<Point>();
				
		//only keep points that € to region
		for(Point p :points){
			if (r.contains(p)){
				insideRegionPoints.add(p);
			}
		}
		
		//keep the closest point
		for(Point p:insideRegionPoints){

			int dx = (int) Math.abs(p1.getX() - p.getX());
			int dy = (int) Math.abs(p1.getY() - p.getY());
			
			if (minDx==-1 && minDy==-1){
				minDx = dx;
				minDy = dy;
				closestPoint = p;
			}
			
			if ( (dx<minDx && dy<minDy) || (dx==minDx && dy<minDy) || (dx<minDx) && dy==minDy){
				minDx = dx;
				minDy = dy;
				closestPoint = p;
			}
			
		}
		
		return closestPoint;
	}
	
	
	/**
	 * Get p2 position relatively to p1
	 * @param p1
	 * @param p2
	 * @return
	 */
	public Direction getDirection(Point p1,Point p2){
		
		//SE
		if (p2.getX()>p1.getX() && p2.getY()>p1.getY()){
			return Direction.SE;
		//SW
		}else if (p2.getX()<p1.getX() && p2.getY()>p1.getY()){
			return Direction.SW;
		//NW	
		}else if (p2.getX()<p1.getX() && p2.getY()<p1.getY()){
			return Direction.NW;
		//NE
		}else if (p2.getX()>p1.getX() && p2.getY()<p1.getY()){
			return Direction.NE;
		//N
		}else if (p2.getX()==p1.getX() && p2.getY()<p1.getY()){
			return Direction.N;
		//S	
		}else if (p2.getX()==p1.getX() && p2.getY()>p1.getY()){
			return Direction.S;
		//W	
		}else if (p2.getX()<p1.getX() && p2.getY()==p1.getY()){
			return Direction.W;
		//E	
		}else if (p2.getX()>p1.getX() && p2.getY()==p1.getY()){
			return Direction.E;
		}
		
		return null;
	}
	
	
	
	public LinearFunction getLinearFunctionFrom2Points(Point point1,Point point2){
		
		float a=0;
		
		float diffY = point2.getY()-point1.getY(); 
		float diffX = point2.getX()-point1.getX();
		
		if (diffX!=0 && diffY!=0) a =  (diffY/(diffX));
		
		float b = (int) (point1.getY() - (a*point1.getX())); 
		
		LinearFunction fn = instance.new LinearFunction(a, b); 
		
		return fn;		
	}
	
	
	public Point getIntesectionPointFromLinearFn(LinearFunction fn1,LinearFunction fn2){
		
		float a = fn2.getA() - fn1.getA();
		float b = fn1.getB() - fn2.getB(); 
		
		float x = b/a;
		
		float y = fn1.getFx(x);
		
		return new Point(x, y);
	}
	
	public double getDistance(double x1,double y1,double x2,double y2){		
		
		double distance = Math.sqrt(
				Math.pow((x2-x1), 2)
				+
				Math.pow((y2-y1), 2)
				);
		
		return distance;
	}
	
	
	
	public class LinearFunction {
		
		private float a;
		private float b;
		
		public LinearFunction(float a,float b) {
			this.a = a;
			this.b = b;
		}
		
		public float getA() {
			return a;
		}
		
		public float getB() {
			return b;
		}
		
		public float getFx(float x){
			return (a*x)+b;
		}
		
		@Override
		public String toString() {
		
			return "f(x)="+a+"x+"+b;
		}
		
	}
	
	
}
