/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.draggable;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElementDefaultHandlers;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;


/**
 * 
 * @author nfleury
 *
 */
public class DraggableElementDefaultHandlers implements IDraggableElementDefaultHandlers{

	private IDraggableElement draggable;
	
	private int draggableInitRelativeX;
	private int draggableInitRelativeY;
	
	private DefaultHandlersConfig config;
	
//	private boolean dragging = false;
	
	private int dx;
	private int dy;
	
	
	public DraggableElementDefaultHandlers(IDraggableElement draggable) {
		
		this.draggable 	= draggable;
		this.config 	= new DefaultHandlersConfig();
		this.attachListeners();
	}
	
	public DefaultHandlersConfig getConfig() {
		return config;
	}
	
	private void attachListeners(){
		
		this.draggable.addMouseDownHandler(new MouseDownHandler() {
			


			@Override
			public void onMouseDown(MouseDownEvent arg0) {
				
				//prevent propagation
				arg0.stopPropagation();
				
				draggableInitRelativeX = new Integer((int) draggable.getRelativeX());
				draggableInitRelativeY = new Integer((int) draggable.getRelativeY());
				

				int actualMouseAbsoluteX = arg0.getClientX();
				int actualMouseAbsoluteY = arg0.getClientY();
				
				//calculate delta between mouse pointer and draggable
				//we do that now because after that we cant rely on draggable positions as it constantly changes
				dx			 = (actualMouseAbsoluteX - draggable.getAbsoluteLeft()) + config.getDXajustment();
				dy			 = (actualMouseAbsoluteY - draggable.getAbsoluteTop()) + config.getDYadjustment();
				
				
				draggable.getMouseState().setMouseDown(true);
				draggable.getMouseState().setMouseUp(false);
				
				GlobalDragData.currentDraggedElement = draggable;
				GlobalDragData.dragXdelta = dx;
				GlobalDragData.dragYdelta = dy;
				GlobalDragData.dragStartInitialX = draggableInitRelativeX;
				GlobalDragData.dragStartInitialY = draggableInitRelativeY;
//				System.out.println("dragStartInitialX"+draggableInitRelativeX);
//				System.out.println("dragStartInitialY"+draggableInitRelativeY);
//				System.out.println("DragXdelta:"+dx);
//				System.out.println("DragYdelta:"+dy);
//				
			}
		});
		
		
		this.draggable.addMouseUpHandler(new MouseUpHandler() {
			
			@Override
			public void onMouseUp(MouseUpEvent arg0) {
				
	
				draggable.getMouseState().setMouseDown(false);
				draggable.getMouseState().setMouseUp(true);

				
			}
		});
		

		
		
		
	}

	

	
	@Override
	public void attachDefaultHandlers() {
		// TODO Auto-generated method stub
		
	}


	@Override
	public IDraggableElement getDraggableElement() {
		return draggable;
	}

	@Override
	public int getDragStartX() {
		return draggableInitRelativeX;
	}

	@Override
	public int getDragStartY() {
		return draggableInitRelativeY;
	}
	
}
