/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.draggable;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableProxyDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.DragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.DragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedBeforeDropEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.Event.NativePreviewEvent;
import com.google.gwt.user.client.Event.NativePreviewHandler;
import com.google.gwt.user.client.ui.RootPanel;


/**
 * 
 * @author nfleury
 *
 */
public class DraggableProxyDefaultHandlers implements IDraggableProxyDefaultHandlers{

	private IHasDragProxy hasDraggableProxy;
		
	private boolean hasMouseDown;
	private boolean dragging;
	
	private DraggableProxy ghostProxy;
	private DropProxyIndicator dropIndicator;
	
	
	public DraggableProxyDefaultHandlers(IHasDragProxy draggable) {
		
		this.hasDraggableProxy = draggable;


	}
	

	@Override
	public void attachDefaultHandlers() {
		
		
		
		hasDraggableProxy.addMouseDownHandler(new MouseDownHandler() {
			
			@Override
			public void onMouseDown(MouseDownEvent event) {
				
				hasMouseDown = true;
				event.preventDefault();
			}
		});
		
		//when mouse is down and when it moves over a HasDraggableProxy
		//we create the default proxy
		hasDraggableProxy.addMouseMoveHandler(new MouseMoveHandler() {
			


			@Override
			public void onMouseMove(MouseMoveEvent event) {
				
				if (hasMouseDown){
					
					int actualX = event.getRelativeX(RootPanel.getBodyElement())+Window.getScrollLeft();
					int actualY = event.getRelativeY(RootPanel.getBodyElement())+Window.getScrollTop();
					
					
					if (ghostProxy==null){
						
						ghostProxy = new DraggableProxy(hasDraggableProxy);
						//ghostProxy.setPixelSize(1, 1);
//						ghostProxy.setStyleName("ui-element");
						
						dropIndicator = new DropProxyIndicator(ghostProxy);
						
						RootPanel.get().add(dropIndicator);
						
						ghostProxy.addDragHandler(new DragHandler() {
							
							@Override
							public void onRefusedBeforeDrop(IRefusedBeforeDropEvent event) {
								
//								System.out.println("Refused bedore drop");
								
								hasDraggableProxy.fireEvent(new ProxyRefusedBeforeDropEvent(ghostProxy, event));
								dropIndicator.dropKO();
							}
							
							@Override
							public void onRefusedAfterDrop(IRefusedAfterDropEvent event) {
								
								hasDraggableProxy.fireEvent(new ProxyRefusedAfterDropEvent(ghostProxy, event));
								
							}
							
							@Override
							public void onAcceptedBeforeDrop(IAcceptedBeforeDropEvent event) {
								
//								System.out.println("Accepted before drop");	
								
								hasDraggableProxy.fireEvent(new ProxyAcceptedBeforeDropEvent(ghostProxy, event));
								dropIndicator.dropOK();
								
							}
							
							@Override
							public void onAcceptedAfterDrop(IAcceptedAfterDropEvent event) {
								
								hasDraggableProxy.fireEvent(new ProxyAcceptedAfterDropEvent(ghostProxy, event));
								
							}
							
							@Override
							public void onStop(IDragStopEvent event) {
							
								hasDraggableProxy.fireEvent(new ProxyDragStopEvent(ghostProxy, event));
								
							}
							
							@Override
							public void onStart(IDragStartEvent event) {
								
								hasDraggableProxy.fireEvent(new ProxyDragStartEvent(ghostProxy, event));
								
							}
							
							@Override
							public void onMove(IDragMoveEvent event) {
								
								hasDraggableProxy.fireEvent(new ProxyDragMoveEvent(ghostProxy,event));
								RootPanel.get().setWidgetPosition(dropIndicator,ghostProxy.getAbsoluteLeft()-10,ghostProxy.getAbsoluteTop());
								//dropIndicator.setAbsoluteTop(ghostProxy.getAbsoluteTop()+10);

							}
						});
						
						
						hasDraggableProxy.setDraggableProxy(ghostProxy);
						
						RootPanel.get().add(ghostProxy,actualX,actualY);
					}else{
						RootPanel.get().setWidgetPosition(ghostProxy, actualX-(ghostProxy.getOffsetWidth()/2), actualY-(ghostProxy.getOffsetHeight()/2));
					}
					
				
					event.preventDefault();
				}
				
			}
		});
		
		
		hasDraggableProxy.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				
				if (hasMouseDown){
			
					//let window take relay
					setWindowMouseMoveListener();
				}
				
			}
		});
		
		NativePreviewHandler nph = new NativePreviewHandler() {
			
			@Override
			public void onPreviewNativeEvent(NativePreviewEvent event) {
				
				if (event.getTypeInt()==Event.ONMOUSEUP){
					dragging = false;
					releaseDragProxy(event.getNativeEvent().getClientX(),
							event.getNativeEvent().getClientY());
					
				}
				
				if (event.getTypeInt()==Event.ONMOUSEMOVE){
					
					//moveDragProxy(event.getNativeEvent().getClientX(), event.getNativeEvent().getClientY());
					
				}
				
			}
		}; 
		
		
		Event.addNativePreviewHandler(nph);
		
		
		
		
		
	}

	
	public void moveDragProxy(int x,int y){ 

		if (hasMouseDown){
			
		
			if (ghostProxy!=null){
				
				if (dragging==false){
					hasDraggableProxy.getUIPanel().getDDManager().dragStartElement(ghostProxy);

					ghostProxy.fireEvent(new DragStartEvent());
				}
				
				dragging = true;
//				System.out.println("DRAG PROXY MOVE");
				RootPanel.get().setWidgetPosition(ghostProxy, x-(ghostProxy.getOffsetWidth()/2)+Window.getScrollLeft(), y-(ghostProxy.getOffsetHeight()/2)+Window.getScrollTop());
				


				ghostProxy.fireEvent(new DragMoveEvent(GlobalDragData.dragStartInitialX, GlobalDragData.dragStartInitialY));
				
				
				hasDraggableProxy.getUIPanel().getDDManager().draggingElement(ghostProxy, x, y);
			}
			
		}
		
	}
	
	public void releaseDragProxy(int x,int y){
		
		if (hasMouseDown){
			
			if (ghostProxy!=null){
				
				ghostProxy.fireEvent(new DragStopEvent(GlobalDragData.dragStartInitialX, GlobalDragData.dragStartInitialY));
				
				hasDraggableProxy.getUIPanel().getDDManager().releasingDragElement(ghostProxy, x, y);
				
				RootPanel.get().remove(ghostProxy);
				RootPanel.get().remove(dropIndicator);
				ghostProxy = null;
			}
			hasMouseDown = false;
		}
		
	}
	

	@Override
	public IHasDragProxy getHasDraggableElementProxy() {
		return hasDraggableProxy;
	}

	/**
	 * TODO: find the GWT way to do that ...
	 */
	public native void setWindowMouseMoveListener()/*-{
		
		$wnd.onmousemove 	= mousemove;

		
		var t = this; 
		
		function mousemove(event){
			
			t.@com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableProxyDefaultHandlers::moveDragProxy(II)(event.clientX,event.clientY);
			
		}

	
	}-*/;

	
}
