/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.uipanel;

import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanelResizeConfiguration;

public class UIPanelResizeConfiguration implements IUIPanelResizeConfiguration{
	
	private int actualHeight;
	private int actualWidth;
	private int decreaseSize;
	private int increaseSize;
	private int maxHeight;
	private int maxWidth;
	private int minHeight;
	private int minWidth;
	private IUIPanel uiPanel;
	
	public UIPanelResizeConfiguration(IUIPanel uipanel) {
		this.uiPanel = uipanel;
	}
	
	
	public void setActualHeight(int actualHeight) {
		this.actualHeight = actualHeight;
	}


	public void setActualWidth(int actualWidth) {
		this.actualWidth = actualWidth;
	}


	public void setDecreaseSize(int decreaseSize) {
		this.decreaseSize = decreaseSize;
	}


	public void setIncreaseSize(int increaseSize) {
		this.increaseSize = increaseSize;
	}


	public void setMaxHeight(int maxHeight) {
		this.maxHeight = maxHeight;
	}


	public void setMaxWidth(int maxWidth) {
		this.maxWidth = maxWidth;
	}


	public void setMinHeight(int minHeight) {
		this.minHeight = minHeight;
	}


	public void setMinWidth(int minWidth) {
		this.minWidth = minWidth;
	}


	@Override
	public int getActualHeight() {
		return actualHeight;
	}

	@Override
	public int getActualWidth() {
		return actualWidth;
	}

	@Override
	public int getDecreaseSize() {
		return decreaseSize;
	}

	@Override
	public int getIncreaseSize() {
		return increaseSize;
	}

	@Override
	public int getMaxHeight() {
		return maxHeight;
	}

	@Override
	public int getMaxWidth() {
		return maxWidth;
	}

	@Override
	public int getMinHeight() {
		return minHeight;
	}

	@Override
	public int getMinWidth() {
		return minWidth;
	}

	@Override
	public IUIPanel getUIPanel() {
		return uiPanel;
	}

}
