/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.uipanel;

import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanelResizeUIHandler;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;


public abstract class UIPanelResizeUIHandler extends Composite implements IUIPanelResizeUIHandler{
	
	private IUIPanel uiPanel;
	private AbsolutePanel mainPanel;
	
	public UIPanelResizeUIHandler(IUIPanel uiPanel) {
		this.uiPanel 	= uiPanel;
		this.mainPanel 	= new AbsolutePanel();
		initWidget(mainPanel);
		
		if (getIncreaseBtn() instanceof Widget && getDecreaseBtn() instanceof Widget){
			
			Widget increase = (Widget) getIncreaseBtn();
			Widget decrease = (Widget) getDecreaseBtn();
			
			mainPanel.add(increase);
			mainPanel.add(decrease);
			
		}else{
			throw new IllegalStateException("Increase and decrease buttons should be instance of "+Widget.class);
		}
		
		this.refresh();
	}
	

	@Override
	public void hide() {
		this.setVisible(false);
	}

	@Override
	public void show() {
		this.setVisible(true);
	}


	@Override
	public IUIPanel getUIPanel() {
		return uiPanel;
	}
	
	protected AbsolutePanel getMainPanel(){
		return this.mainPanel;
	}
	
	@Override
	public void setWidth(int width) {
		this.mainPanel.setWidth(""+width);
	}
	
	@Override
	public void setHeight(int height) {
		this.mainPanel.setHeight(""+height);
	}

	
}
