/**
 * geasy-widgets-gwtext - Geasy widgets implementation with GWT-Ext library - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.gwtextwidgets.file;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFile;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FilesSelectedEvent;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.DateFieldDef;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.CheckboxColumnConfig;
import com.gwtext.client.widgets.grid.CheckboxSelectionModel;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.GridPanel;
import com.gwtext.client.widgets.grid.RowSelectionModel;
import com.gwtext.client.widgets.grid.event.RowSelectionListenerAdapter;

public class FilePanel extends
com.ebmwebsourcing.geasytools.widgets.ext.impl.file.FilePanel {

	private GridPanel gridPanel;
	private CheckboxSelectionModel cbSelectionModel;

	public FilePanel() {
		buildGrid();
		initWidget(gridPanel);
	}

	private void buildGrid(){
		this.cbSelectionModel = new CheckboxSelectionModel();  

		this.cbSelectionModel.addListener(new RowSelectionListenerAdapter(){
			@Override
			public void onRowSelect(RowSelectionModel sm, int rowIndex,
					Record record) {
				HashSet<IFile> files  = new HashSet<IFile>();
				List<IFile> selectedFiles = getSelectedFiles();
				for(IFile f : selectedFiles){
					files.add(f);
				}
				fireEvent(new FilesSelectedEvent(files));
			}
		});

		this.gridPanel = new GridPanel();  
		MemoryProxy proxy = new MemoryProxy(new Object[0][4]);  
		RecordDef recordDef = new RecordDef(  
				new FieldDef[]{  
						new StringFieldDef("name"),
						new DateFieldDef("creationdate", "n/j h:ia"),
						new DateFieldDef("lastmodifieddate", "n/j h:ia"),
						new ObjectFieldDef("file")
				}  
				);  

		ArrayReader reader = new ArrayReader(recordDef);  
		Store store = new Store(proxy, reader);  
		store.load(); 

		gridPanel.setStore(store);  

		BaseColumnConfig[] columns = new BaseColumnConfig[]{  
				new CheckboxColumnConfig(cbSelectionModel),  
				new ColumnConfig("Name", "name", 160, true, null, "name"),  
				new ColumnConfig("Creation date", "creationdate", 65),  
				new ColumnConfig("Last modified date", "lastmodifieddate", 65),  
		};  

		ColumnModel columnModel = new ColumnModel(columns);  
		gridPanel.setColumnModel(columnModel);  

		gridPanel.setFrame(true);  
		gridPanel.setStripeRows(true);  
		gridPanel.setAutoExpandColumn("name");  

		gridPanel.setSelectionModel(cbSelectionModel);  
		gridPanel.setFrame(true);  
		gridPanel.setIconCls("grid-icon");  
	}

	@Override
	public void setFiles(List<IFile> files) {
		Object[][] data = getData(files);  
		MemoryProxy proxy = new MemoryProxy(data);  

		gridPanel.getStore().setDataProxy(proxy);
		gridPanel.getStore().load();

		gridPanel.doLayout();

		super.setFiles(files);
	}

	private List<IFile> getSelectedFiles(){
		Record[] records = cbSelectionModel.getSelections();  
		ArrayList<IFile> selectedFiles = new ArrayList<IFile>();
		for (int i = 0; i < records.length; i++) {  
			Record record = records[i];  
			selectedFiles.add((IFile) record.getAsObject("file"));
		}  
		return selectedFiles;
	}

	private Object[][] getData(List<IFile> files) {
		Object[][] objects = new Object[files.size()][4];
		for(int i=0;i<files.size();i++){
			objects[i][0] = files.get(i).getName();
			objects[i][1] = files.get(i).getCreationDate();
			objects[i][2] = files.get(i).getLastModificationDate();
			objects[i][3] = files.get(i);
		}
		return objects;
	}

	@Override
	public void setTitle(String title) {
		gridPanel.setTitle(title);
	}

	@Override
	public void setHeight(int height) {
		gridPanel.setHeight(height);
	}

	@Override
	public void setWidth(int width) {	
		gridPanel.setWidth(width);
	}

}
