/**
 * geasy-widgets-gwtext - Geasy widgets implementation with GWT-Ext library - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.gwtextwidgets.tabpanel;

import java.util.HashMap;

import com.ebmwebsourcing.geasytools.gwtextwidgets.treepanel.TreeNode;
import com.ebmwebsourcing.geasytools.gwtextwidgets.treepanel.TreePanel;
import com.ebmwebsourcing.geasytools.widgets.core.api.panel.IPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.tabpanel.IComplexTabPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.treepanel.ITreeNode;
import com.ebmwebsourcing.geasytools.widgets.ext.api.treepanel.ITreePanel;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.tabpanel.AbstractTabPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.tabpanel.event.PanelSelectedEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.layout.HorizontalLayout;

public class ComplexTabPanel extends AbstractTabPanel implements IComplexTabPanel{
	
	private TreePanel treePanel;
	private Panel mainPanel;
	private Panel panelContainer;
	private HashMap<IPanel,ITreeNode> panelTreeNodes;
	private HashMap<IPanel,IPanel> panelParentPanel;

	
	public ComplexTabPanel() {
		
		this.panelTreeNodes = new HashMap<IPanel, ITreeNode>();
		this.panelParentPanel = new HashMap<IPanel, IPanel>();
		
		this.treePanel = new TreePanel(new TreeNode());
		this.mainPanel = new Panel();
		this.mainPanel.setAutoScroll(true);
		this.mainPanel.setMargins(0);
		this.mainPanel.setPaddings(0);
		this.mainPanel.setLayout(new HorizontalLayout(2));
		this.mainPanel.setVisible(false);
		this.panelContainer = new Panel();
		this.panelContainer.setBorder(false);


		//this.panelContainer.setPixelSize(200, 200);
		this.mainPanel.add((Widget) treePanel);
		this.mainPanel.add(panelContainer);
		
		
		
		
		initWidget(mainPanel);
		
	}
	
	@Override
	protected void onLoad() {
		mainPanel.setVisible(true);
		mainPanel.doLayout();
		super.onLoad();
	}
	

	
	
	@Override
	public ITreePanel getTreePanel() {
		return treePanel;
	}

	@Override
	public void setTreePanelPixelSize(int width, int height) {
		this.treePanel.setPixelSize(width, height);
	}
	
	@Override
	public void addPanel(final IPanel panel) {
		
		if (contains(panel)==false){
			
			//adding a panel automatically adds a node
			TreeNode treeNode = new TreeNode();
			treeNode.setText(panel.getTitle());
			
			panelTreeNodes.put(panel, treeNode);
			
			treeNode.addClickHandler(new ClickHandler() {
				
				@Override
				public void onClick(ClickEvent event) {
					
					fireEvent(new PanelSelectedEvent(panel));
					activatePanel(panel);
				}
			});
			
			
			//add node to root only if actual panel doesnt have a parent
			IPanel parentPanel = this.panelParentPanel.get(panel); 
			if (parentPanel==null){
			
				this.treePanel.getRootNode().addNode(treeNode);
			
			}else{
				
				this.panelTreeNodes.get(parentPanel).addNode(treeNode);
				
			}
			
			panelContainer.add((Widget) panel);
			//panelContainer.doLayout();
			this.mainPanel.doLayout();
			
	
			
			super.addPanel(panel);
			
			activatePanel(panel);
		
		}
	}
	
	private boolean contains(IPanel panel){
		
		for(IPanel p:getPanels()){
			
			if (p==panel){
				return true;
			}
			
		}
		
		return false;
	}
	
	@Override
	public void addPanel(IPanel panel, IPanel parentPanel) {
		
		this.panelParentPanel.put(panel, parentPanel);
		
		this.addPanel(panel);
	}


	
	public void activatePanel(IPanel panel){

		for(int i=0;i<this.getPanels().length;i++){
			
			this.getPanels()[i].asWidget().setVisible(false);
			
			if (this.getPanels()[i]==panel){
			panel.asWidget().setVisible(true);
			treePanel.setActiveItem(panelTreeNodes.get(panel));
			}
			
		}
		
	}
	

	@Override
	public void removeAllPanels() {
		
		for(IPanel p:panelTreeNodes.keySet()){
			
			removePanel(p);
			
		}
		
	}

	@Override
	public void removePanel(IPanel panel) {
		//removing a panel means removing the node
		//TODO: truly remove the widget may cause some display issues 
		//panelContainer.remove((Widget)panel);
		//this is why it is simply hidden ... find why !!
		panel.asWidget().setVisible(false);
		
		//retrieve node and remove it
		ITreeNode node = panelTreeNodes.get(panel);
		
		treePanel.removeNode(node);
		panelTreeNodes.remove(panel);
		panelParentPanel.remove(panel);
		
		super.removePanel(panel);
	}


}
