/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IBindedModelProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IWatchedModelProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.SampleBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.SampleModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.SampleWatchedModel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import java.util.ArrayList;

public class ModelBinderTestGwt
extends GWTTestCase {
    public String getModuleName() {
        return "com.ebmwebsourcing.geasytools.modeleditor.modelmanager.ModelManager";
    }

    public void testBindedModelProxy() {
        SampleModel.SampleModelBindedModel proxy = (SampleModel.SampleModelBindedModel)GWT.create(SampleModel.SampleModelBindedModel.class);
        SampleModel sampleModel = new SampleModel();
        ModelBinderTestGwt.assertNull((Object)proxy.getBindedModel());
        proxy.setBindedModel(sampleModel);
        ModelBinderTestGwt.assertEquals((Object)sampleModel, (Object)proxy.getBindedModel());
        ArrayList<String> value = new ArrayList<String>();
        value.add("e1");
        proxy.setFieldValue("list", value);
        ModelBinderTestGwt.assertEquals(value, sampleModel.getList());
        ModelBinderTestGwt.assertEquals((int)0, (int)((int)sampleModel.getNumber()));
        proxy.setFieldValue("number", new Double(10.0));
        ModelBinderTestGwt.assertEquals((int)10, (int)((int)sampleModel.getNumber()));
    }

    public void testSimpleBinding() {
        SampleWatchedModel watchedModel = (SampleWatchedModel)GWT.create(SampleWatchedModel.class);
        IWatchedModelProxy proxy = (IWatchedModelProxy)watchedModel;
        ModelBinderTestGwt.assertNotNull((Object)proxy.getBinder());
        ModelBinderTestGwt.assertNotNull((Object)proxy.getBindedModel());
        watchedModel.setStringList("e1,e2");
        ModelBinderTestGwt.assertTrue((((SampleModel)proxy.getBindedModel()).getList().size() == 2 ? 1 : 0) != 0);
        watchedModel.setStringList("e1");
        ModelBinderTestGwt.assertTrue((((SampleModel)proxy.getBindedModel()).getList().size() == 1 ? 1 : 0) != 0);
        watchedModel.setStringList("e1,e2,e3");
        ModelBinderTestGwt.assertTrue((((SampleModel)proxy.getBindedModel()).getList().size() == 3 ? 1 : 0) != 0);
        IBindedModelProxy bindedModelProxy = proxy.getBindedModelProxy();
        ModelBinderTestGwt.assertEquals((int)0, (int)((int)((SampleModel)proxy.getBindedModel()).getNumber()));
        bindedModelProxy.setFieldValue("number", new Double(10.0));
        ModelBinderTestGwt.assertEquals((int)10, (int)((int)((SampleModel)proxy.getBindedModel()).getNumber()));
    }

    public void testWatchedModelInitialization() {
        SampleModel sampleModel = new SampleModel();
        sampleModel.addElement("e1");
        sampleModel.addElement("e2");
        SampleWatchedModel watchedModel = (SampleWatchedModel)GWT.create(SampleWatchedModel.class);
        IWatchedModelProxy proxy = (IWatchedModelProxy)watchedModel;
        proxy.setBindedModel((Object)sampleModel);
        ModelBinderTestGwt.assertEquals((String)"e1,e2", (String)watchedModel.getStringList());
        watchedModel.setStringList("e1");
        ModelBinderTestGwt.assertEquals((int)1, (int)((SampleModel)proxy.getBindedModel()).getList().size());
    }

    public void testLinkedBindedModel() {
        SampleWatchedModel watchedModel1 = (SampleWatchedModel)GWT.create(SampleWatchedModel.class);
        IWatchedModelProxy proxy1 = (IWatchedModelProxy)watchedModel1;
        SampleWatchedModel watchedModel2 = (SampleWatchedModel)GWT.create(SampleWatchedModel.class);
        IWatchedModelProxy proxy2 = (IWatchedModelProxy)watchedModel2;
        proxy2.setBindedModel(proxy1.getBindedModel());
        ModelBinderTestGwt.assertTrue((proxy1.getBindedModel() == proxy2.getBindedModel() ? 1 : 0) != 0);
        watchedModel1.setStringList("e1,e2,e3");
        ModelBinderTestGwt.assertTrue((((SampleModel)proxy1.getBindedModel()).getList().size() == 3 ? 1 : 0) != 0);
        ModelBinderTestGwt.assertTrue((((SampleModel)proxy2.getBindedModel()).getList().size() == 3 ? 1 : 0) != 0);
        watchedModel2.setStringList("e1");
        ModelBinderTestGwt.assertTrue((((SampleModel)proxy1.getBindedModel()).getList().size() == 1 ? 1 : 0) != 0);
        ModelBinderTestGwt.assertTrue((((SampleModel)proxy2.getBindedModel()).getList().size() == 1 ? 1 : 0) != 0);
    }

    public void testGeneratedBinder() {
        SampleBinder binder = (SampleBinder)GWT.create(SampleBinder.class);
        SampleModel model = new SampleModel();
        SampleWatchedModel watchedModel = new SampleWatchedModel();
        watchedModel.setStringList("e1,e2");
        binder.bind(watchedModel, model);
        ModelBinderTestGwt.assertTrue((model.getList().size() == 2 ? 1 : 0) != 0);
        watchedModel.setStringList("");
        ModelBinderTestGwt.assertTrue((boolean)watchedModel.getStringList().equals(""));
        binder.initializeWatchedModel(watchedModel, model);
        ModelBinderTestGwt.assertTrue((boolean)watchedModel.getStringList().equals("e1,e2"));
    }
}

