/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.Constants;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.IHasReflectionHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.IHasReflectionProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.ModelWithEnum;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.ModelWithPrimitives;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.MyEnum;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.SuperModelWithEnum;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.event.IFieldValueChangedEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test.DummyModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.Field;
import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import junit.framework.Assert;

public class ReflectionTestGwt
extends GWTTestCase {
    private int cpt;

    public String getModuleName() {
        return "com.ebmwebsourcing.geasytools.modeleditor.modelmanager.ModelManager";
    }

    public void testReflection() {
        try {
            DummyModel model = (DummyModel)GWT.create(DummyModel.class);
            IHasReflectionProxy proxy = (IHasReflectionProxy)model;
            ReflectionTestGwt.assertTrue((proxy.getFields().size() == 2 ? 1 : 0) != 0);
            ReflectionTestGwt.assertTrue((boolean)model.getString1().equals("state0"));
            proxy.setFieldValue("string1", (Object)"state1");
            ReflectionTestGwt.assertTrue((boolean)model.getString1().equals("state1"));
            ReflectionTestGwt.assertEquals(DummyModel.class, (Object)proxy.getRealType());
        }
        catch (Throwable t) {
            t.printStackTrace();
            ReflectionTestGwt.fail();
        }
    }

    public void testReflectionHandler() {
        DummyModel model = (DummyModel)GWT.create(DummyModel.class);
        IHasReflectionProxy proxy = (IHasReflectionProxy)model;
        final StringBuilder sb = new StringBuilder();
        proxy.addHandler(new IHasReflectionHandler(){

            public void onFieldValueChanged(IFieldValueChangedEvent event) {
                sb.append(event.getFieldName() + "=>" + event.getValue());
            }
        });
        proxy.setFieldValue("string1", (Object)"state1");
        ReflectionTestGwt.assertTrue((sb.length() > 0 ? 1 : 0) != 0);
    }

    public void testReflectionWithPrimitives() {
        ModelWithPrimitives model = (ModelWithPrimitives)GWT.create(ModelWithPrimitives.class);
        IHasReflectionProxy proxy = (IHasReflectionProxy)model;
        proxy.setFieldValue("property1", Double.valueOf(10.5));
        ReflectionTestGwt.assertTrue((model.getProperty1() == 10.5 ? 1 : 0) != 0);
        ReflectionTestGwt.assertFalse((boolean)model.isProperty2());
        proxy.setFieldValue("property2", Boolean.valueOf(true));
        ReflectionTestGwt.assertTrue((boolean)model.isProperty2());
        proxy.setFieldValue("property3", (Object)"value3");
        ReflectionTestGwt.assertTrue((boolean)model.getProperty3().equals("value3"));
    }

    public void testReflectionCopy() {
        DummyModel model = (DummyModel)GWT.create(DummyModel.class);
        IHasReflectionProxy proxy = (IHasReflectionProxy)model;
        DummyModel modelToCopy = (DummyModel)GWT.create(DummyModel.class);
        modelToCopy.setString1("myString");
        ReflectionTestGwt.assertEquals((String)"state0", (String)model.getString1());
        proxy.copy((IHasReflectionProxy)modelToCopy);
        ReflectionTestGwt.assertEquals((String)"myString", (String)model.getString1());
    }

    public void testReflectionWithEnum() {
        ModelWithEnum model = (ModelWithEnum)GWT.create(ModelWithEnum.class);
        IHasReflectionProxy proxy = (IHasReflectionProxy)model;
        ReflectionTestGwt.assertTrue((model.getProperty4() == MyEnum.CONST1 ? 1 : 0) != 0);
        proxy.setFieldValue("property4", (Object)MyEnum.CONST3);
        ReflectionTestGwt.assertTrue((model.getProperty4() == MyEnum.CONST3 ? 1 : 0) != 0);
        ReflectionTestGwt.assertTrue((model.getProperty5() == null ? 1 : 0) != 0);
        proxy.setFieldValue("property5", (Object)Constants.MyEnum2.E1);
        ReflectionTestGwt.assertTrue((model.getProperty5() == Constants.MyEnum2.E1 ? 1 : 0) != 0);
    }

    public void testReflectionWithInheritance() {
        ModelWithEnum model1 = (ModelWithEnum)GWT.create(ModelWithEnum.class);
        SuperModelWithEnum model2 = (SuperModelWithEnum)GWT.create(SuperModelWithEnum.class);
        ReflectionTestGwt.assertEquals((Object)((Object)MyEnum.CONST1), (Object)((Object)model1.getProperty4()));
        ReflectionTestGwt.assertEquals((Object)((Object)MyEnum.CONST2), (Object)((Object)model2.getProperty4()));
        IHasReflectionProxy proxy2 = (IHasReflectionProxy)model2;
        ReflectionTestGwt.assertEquals((Object)((Object)MyEnum.CONST2), (Object)((Field)proxy2.getFields().get("property4")).getValue());
    }

    public void testSetFieldValueEvent() {
        DummyModel model = (DummyModel)GWT.create(DummyModel.class);
        IHasReflectionProxy proxy = (IHasReflectionProxy)model;
        String newString1 = "newString1";
        this.cpt = 0;
        proxy.addHandler(new IHasReflectionHandler(){

            public void onFieldValueChanged(IFieldValueChangedEvent event) {
                Assert.assertEquals((Object)"newString1", (Object)event.getValue());
                ReflectionTestGwt.this.cpt++;
            }
        });
        model.setString1("newString1");
        ReflectionTestGwt.assertEquals((int)1, (int)this.cpt);
    }
}

