/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client;

public class Utils {

	public static String getFieldNameByMethodName(String methodName){
		
		String result = null;
		
		if (methodName.startsWith("set")) 	result = 	methodName.toLowerCase().replace("set", "");
		if (methodName.startsWith("get")) 	result = 	methodName.toLowerCase().replace("get", "");
		if (methodName.startsWith("is")) 	result =	methodName.toLowerCase().replace("is", "");
		
		return result;
	}
	
	public static String getOppositeMethodName(String methodName){
		
	String oppositeMethodName;
		
		if (methodName.startsWith("set")){
			
			oppositeMethodName = methodName.replace("set", "get");
			
		}else if (methodName.startsWith("get")){
			
			oppositeMethodName = methodName.replace("get", "set");
			
		}else{
			
			throw new RuntimeException("Could not find the opposite method for"+ methodName);
			
		}
		
		
		return oppositeMethodName;
		
		
	}
	
	
	public static String getSetterMethodByFieldName(String fieldName){
		
	    String forename = fieldName;
	    String forenameInitial = "";

	    //forename = forename.toLowerCase();
	    forenameInitial = forename.substring(0, 1).toUpperCase();
	    forename = forenameInitial + forename.substring(1,forename.length());
		
		return "set"+forename;	
	}

	public static String getGetterMethodByFieldName(String fieldName, boolean b) {
	    String forename = fieldName;
	    String forenameInitial = "";

	    //forename = forename.toLowerCase();
	    forenameInitial = forename.substring(0, 1).toUpperCase();
	    forename = forenameInitial + forename.substring(1,forename.length());
	    
	    if (b){
	    	return "is"+forename;
	    }
	    
		return "get"+forename;	
	}
	
	public static String getAdderMethodByFieldName(String fieldName) {
		return "add"+getAdderOrRemoverNameEnd(fieldName);	
	}
	
	public static String getRemoverMethodByFieldName(String fieldName) {
		return "remove"+getAdderOrRemoverNameEnd(fieldName);	
	}
	
	private static String getAdderOrRemoverNameEnd(String fieldName) {
		String forenameInitial = fieldName.substring(0, 1).toUpperCase();
	    String forename = forenameInitial + fieldName.substring(1,fieldName.length());
	    if(forename.endsWith("s")) {
	    	forename = forename.substring(0,forename.lastIndexOf("s"));
	    }
	    return forename;
	}
	
	
}
