/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IMethodCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IObservableHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.ISetterCalledEvent;

public class BinderHandler implements IObservableHandler {
	
	private IWatchedModelProxy<?> proxy;
	private IBinder<IHasModelBinder, Object> binder;
	private Object bindedModel;
	
	public BinderHandler(IWatchedModelProxy<?> proxy,IBinder<IHasModelBinder, Object> binder,Object bindedModel) {
		this.proxy 			= proxy;
		this.binder 		= binder;
		this.bindedModel 	= bindedModel;
	}
	
	@Override
	public void onMethodCalled(IMethodCalledEvent event) {}

	@Override
	public void onSetterCalled(ISetterCalledEvent event) {
		binder.bind((IHasModelBinder)proxy, bindedModel);
	}
	
	public void setBindedModel(Object bindedModel) {
		this.bindedModel = bindedModel;
	}

}
