/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder;

import java.util.ArrayList;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.IHasReflectionProxy;


public class HasEditorProxyImpl implements IHasEditorProxy{
	
	private IHasEditorProxy proxy;
	private IHasReflectionProxy reflectionProxy;

	private ITemplate template;
	private IWidgetProvider widgetProvider;
	private ITemplate editor;
	
	public HasEditorProxyImpl(IHasEditorProxy proxy) {
		
		this.proxy			 = proxy;
		this.reflectionProxy = (IHasReflectionProxy) proxy;

		this.widgetProvider	 = new WidgetProvider(new ArrayList<Field>(this.reflectionProxy.getFields().values()),proxy);
	
	}
	
	public void setTemplate(ITemplate template){
		this.template = template;
	}
	
	public void registerWidgetInstantiationHandler(String name,IWidgetInstantiationHandler<UIFieldWidget<?>> wih){
		this.widgetProvider.registerWidgetInstantiationHandler(name, wih);
	}
	
	public void registerLabel(String fieldName,String label){
		this.widgetProvider.registerLabel(fieldName, label);
	}
	
	public void registerPosition(String fieldName,int position){
		this.widgetProvider.registerOrder(fieldName, position);
	}
	
	@Override
	public ITemplate getEditor(Object dataProvider) {
		
		if (editor==null){
			
			widgetProvider.setDataProvider(dataProvider);
			
			this.template.onBind(widgetProvider);
			
			this.editor = this.template;
			
		}
		

		
		return editor;
	}





}
