/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.IObservableProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IMethodCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IObservableHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.ISetterCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.IHasReflectionHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.IHasReflectionProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.event.IFieldValueChangedEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;

@SuppressWarnings("unused")
public class WidgetProvider implements IWidgetProvider{


	private HashMap<String, IWidgetInstantiationHandler<UIFieldWidget<?>>> wihByFieldName;
	private HashMap<String, String> labelByFieldNames;
	private Object dataProvider;
	private ArrayList<String> fieldsName;
	private IObservableProxy hasEditorObservaleProxy;
	private IHasReflectionProxy hasEditorReflectionProxy;
	private IHasEditorProxy hasEditorProxy;
	
	private HashMap<String,UIFieldWidget<?>> bindedWidgetRegistry;
	private HashMap<String, Field> fieldByName;
	private HashMap<String, Integer> positionByFieldName;
	private HashMap<Integer,String> fieldNameByPosition;
	
	public WidgetProvider(List<Field> fields,IHasEditorProxy hasEditorProxy) {

		this.hasEditorProxy				= hasEditorProxy;
		this.labelByFieldNames 			= new HashMap<String, String>();
		this.fieldsName 	   			= new ArrayList<String>();
		this.wihByFieldName    			= new HashMap<String, IWidgetInstantiationHandler<UIFieldWidget<?>>>();
		this.hasEditorObservaleProxy	= (IObservableProxy) hasEditorProxy;
		this.hasEditorReflectionProxy	= (IHasReflectionProxy) hasEditorProxy; 
		
		this.bindedWidgetRegistry	= new HashMap<String, UIFieldWidget<?>>();
		this.fieldByName			= new HashMap<String, Field>();
		this.positionByFieldName		= new HashMap<String, Integer>();
		this.fieldNameByPosition		= new HashMap<Integer, String>();
		
		for(Field f:fields){
			
			fieldsName.add(f.getName());
			fieldByName.put(f.getName(), f);
			
		}
	
	}
	
	public void registerWidgetInstantiationHandler(String name,IWidgetInstantiationHandler<UIFieldWidget<?>> wih){
		this.wihByFieldName.put(name, wih);
	}
	

	@SuppressWarnings("unchecked")
	public UIFieldWidget getUIField(final String fieldName) {
		
		//already binded ?
		UIFieldWidget widget = bindedWidgetRegistry.get(fieldName);
		
		
		
		//nope
		if (widget==null){
			
			IWidgetInstantiationHandler<UIFieldWidget<?>> ih = wihByFieldName.get(fieldName);
			
			if (ih==null){
				throw new IllegalStateException("No instantiation handler registered for field "+fieldName);
			}
			
			widget = ih.instantiate();
			widget.setDataProvider(dataProvider);
			
			//initialize field value
			final Field f = fieldByName.get(fieldName);
			widget.setValue(f.getValue(), false);
			
			IObservableProxy observableProxy = hasEditorObservaleProxy;
			IHasReflectionProxy reflectionProxy = hasEditorReflectionProxy;
			///bind field with widget
				
				
//			observableProxy.addHandler((IObservableHandler)new WidgetHandler(widget, fieldName));
//			reflectionProxy.addHandler((IHasReflectionHandler)new WidgetHandler(widget, fieldName));
//				//when field value changes => change uiwidget value
//				if (observableProxy instanceof ISynchronizedProxy){
//					
//					ISynchronizedProxy syncedProxy = (ISynchronizedProxy) observableProxy;
//					
//					IHasSynchronizerProxy synczerProxy 	= (IHasSynchronizerProxy) syncedProxy.getSynchronizedModel();
//					
//					observableProxy 					= (IObservableProxy) synczerProxy;
//					
//				}
				
				observableProxy.addHandler((IObservableHandler)new WidgetHandler(widget, fieldName));
				reflectionProxy.addHandler((IHasReflectionHandler)new WidgetHandler(widget, fieldName));
				


				//when uiwidget value changes => change field value
				
				widget.addValueChangeHandler(new ValueChangeHandler() {
					@Override
					public void onValueChange(ValueChangeEvent event) {
						
						f.setValue(event.getValue());
						
						//if model is synchronized with other models, also set the other field values
//						if (hasEditorProxy instanceof IHasSynchronizerProxy){
//						
//							IHasSynchronizerProxy synchronizerProxy = (IHasSynchronizerProxy) hasEditorObservaleProxy;
//							
//							for(ISynchronized sync:synchronizerProxy.getAll()){
//								
//								IObservableProxy p = (IObservableProxy) sync;
//								
//								for(Field pField:p.getFields().values()){
//									
//									if (pField.getName().equals(f.getName())){
//										
//										pField.setValue(event.getValue());
//										
//									}
//								
//								}
//								
//							}
//						
//						}
						
						//hasEditorReflectionProxy.setFieldValue(fieldName, event.getValue());
						
					}
				});
			
			bindedWidgetRegistry.put(fieldName, widget);
		}
		
		return widget;
	}


	

	@Override
	public void setDataProvider(Object dataProvider) {
		this.dataProvider = dataProvider;
	}



	@Override
	public String getLabel(String fieldName) {
		return labelByFieldNames.get(fieldName);
	}

	@Override
	public void registerLabel(String fieldName, String label) {
		this.labelByFieldNames.put(fieldName, label);
	}



	@Override
	public List<String> getOrderedFieldsName() {
		
		ArrayList<String> result 	= new ArrayList<String>();
		
		Collection<Integer> orders 	= positionByFieldName.values();
		Integer[] os = orders.toArray(new Integer[orders.size()]);
		Arrays.sort(os);
		
		int i = 0;
		for(Integer integer:os){
			
			result.add(i,fieldNameByPosition.get(integer));
			
			i++;
		}
		
		return result;
	}
	
	private class WidgetHandler implements IObservableHandler,IHasReflectionHandler{
		
		private UIFieldWidget widget;
		private String fieldName;
		
		public WidgetHandler(UIFieldWidget widget,String fieldName) {
		
			this.widget = widget;
			this.fieldName = fieldName;
			
		}
		
		@Override
		public void onMethodCalled(IMethodCalledEvent event) {

			
		}

		@Override
		public void onSetterCalled(ISetterCalledEvent event) {
			
			if (event.getField().getName().equals(fieldName)){
				widget.setValue(event.getField().getValue(), false);
			}
			
		}

		@Override
		public void onFieldValueChanged(IFieldValueChangedEvent event) {

			if (event.getFieldName().equals(fieldName)){
//				System.out.println("Reflection setFielfValue("+event.getFieldName()+","+event.getValue()+")");
				widget.setValue(event.getValue(), false);
			}
			
		}

	}

	@Override
	public void registerOrder(String fieldName, int position) {
		this.positionByFieldName.put(fieldName, position);
		this.fieldNameByPosition.put(position, fieldName);
	}

	@Override
	public int getOrder(String fieldName) {
		return this.positionByFieldName.get(fieldName);
	}
	


}
