/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.detachable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.Utils;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.detachable.IDetachableProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.detachable.IDetacher;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Body;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ClassTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Clazz;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.ComposerHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Field;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.JClassTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.JTypeHelper;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Method;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper.Visibility;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JType;

public class DetachableProxyGenerator extends Generator {

	private static final String generatedClassSuffix = "_DetachableProxy";
	private static final String detacherName = "detacher";
	private static final String detacherClassSuffix = "_Detacher_Generated";
	private static final String mapName = "alreadyDetached";

	private String generatedClassName;
	private String detacherClassName;
	private Clazz innerClass;
	private JClassType type;
	private ComposerHelper composerHelper;
	private int varCount = 0;


	@Override
	public String generate(TreeLogger logger, GeneratorContext context,
			String typeName) throws UnableToCompleteException {

		generatedClassName = type.getSimpleSourceName()+generatedClassSuffix;
		detacherClassName = type.getSimpleSourceName()+detacherClassSuffix;
		composerHelper	= new ComposerHelper(context, logger, type.getPackage().getName(), generatedClassName);
		composerHelper.setSuperClass(typeName);//typeName should be the name of a reflection proxy
		composerHelper.addImport(HashMap.class);

		composerHelper.addInterface(IDetachableProxy.class.getCanonicalName()+"<"+type.getSimpleSourceName()+">");

		createFields();

		createContructor();

		createGetDetachedModelMethods();

		createDetacherPrivateClass();

		composerHelper.commit();
		return composerHelper.getCreatedClassName();
	}


	private void createFields(){
		Field detacherField = new Field(Visibility.PRIVATE, IDetacher.class, detacherName);
		composerHelper.addField(detacherField);
	}


	private void createContructor() {
		Method constructor = new Method(Visibility.PUBLIC, generatedClassName);
		constructor.getBody().append(detacherName+" = new "+detacherClassName+"()");
		composerHelper.addMethod(constructor);
	}


	private void createGetDetachedModelMethods() {
		Method m1 = new Method(Visibility.PUBLIC, "getDetachedModel");
		m1.setReturnType(JTypeHelper.getClass(type));

		m1.getBody().append("return ("+type.getQualifiedSourceName()+") "+detacherName+".detach(this)");

		composerHelper.addMethod(m1);
		
		
		Method m2 = new Method(Visibility.PUBLIC, "getDetachedModel");
		m2.setReturnType(JTypeHelper.getClass(type));
		m2.addParameter(m2.new Parameter(Map.class, mapName));

		m2.getBody().append("return ("+type.getQualifiedSourceName()+") "+detacherName+".detach(this,"+mapName+")");

		composerHelper.addMethod(m2);
	}


	private void createDetacherPrivateClass() {
		innerClass = new Clazz(Visibility.PRIVATE, detacherClassName, false);
		innerClass.addInterface(IDetacher.class.getCanonicalName()+"<"+type.getQualifiedSourceName()+","+type.getQualifiedSourceName()+generatedClassSuffix+">");

		generateDetachMethod();
		
		generateMainDetachMethod();

		composerHelper.addInnerClass(innerClass);
	}
	
	
	private void generateDetachMethod() {
		Class<?> returnType = JTypeHelper.getClass(type);
		String detachableProxyType = type.getQualifiedSourceName()+generatedClassSuffix;
		
		Method detachMethod = new Method(Visibility.PUBLIC, "detach");
		detachMethod.setReturnType(returnType);
		String methodParam = "detachableModel";
		detachMethod.addParameter(detachMethod.new Parameter(detachableProxyType, methodParam));
		
		detachMethod.getBody().append("return detach("+methodParam+", new HashMap())");
		
		innerClass.addMethod(detachMethod);
	}
	
	
	private void generateMainDetachMethod() {
		Class<?> returnType = JTypeHelper.getClass(type);
		String detachableProxyType = type.getQualifiedSourceName()+generatedClassSuffix;
		
		Method detachMethod = new Method(Visibility.PUBLIC, "detach");
		detachMethod.setReturnType(returnType);
		String methodParam = "detachableModel";
		detachMethod.addParameter(detachMethod.new Parameter(detachableProxyType, methodParam));
		detachMethod.addParameter(detachMethod.new Parameter(Map.class, mapName));

		String resultVarName = "res";
		detachMethod.getBody().append(returnType.getCanonicalName()+" "+resultVarName+" = new "+returnType.getCanonicalName()+"()");
		detachMethod.getBody().append(mapName+".put("+methodParam+","+resultVarName+")");

		JClassTypeHelper helper = new JClassTypeHelper(type);
		for(JField field : helper.getAllFields()){
			if (!ignoreField(field)){
				boolean isBoolean = field.getType().getQualifiedSourceName().equals(boolean.class.getCanonicalName()) || field.getType().getQualifiedSourceName().equals(Boolean.class.getCanonicalName());
				String getter = Utils.getGetterMethodByFieldName(field.getName(), isBoolean);
				String setter = Utils.getSetterMethodByFieldName(field.getName());
				
				String detachedElt = appendDetachingCode(methodParam+"."+getter+"()", field.getType(), detachMethod.getBody());
				
				detachMethod.getBody().append(resultVarName+"."+setter+"("+detachedElt+")");
			}
		}

		detachMethod.getBody().append("return "+resultVarName);
		innerClass.addMethod(detachMethod);
	}

	
	private String appendDetachingCode(String detachSourceName, JType detachSourceType, Body detachMethodBody) {
		Class<?> detachSourceClass = JTypeHelper.getClass(detachSourceType);
		String detachSourceClassName = detachSourceClass.getCanonicalName();
		
		if(Collection.class.isAssignableFrom(detachSourceClass)) {
			String collectionName = getVariableName();
			JClassType collectionParamType = detachSourceType.isParameterized().getTypeArgs()[0];
			String collectionParamTypeName = collectionParamType.getQualifiedSourceName();
			
			detachMethodBody.append(detachSourceClassName+"<"+collectionParamTypeName+"> "+collectionName+" = new "+ClassTypeHelper.getCollectionSubTypeName(detachSourceClass)+"<"+collectionParamTypeName+">()");

			String collectionEltName = getVariableName();
			detachMethodBody.append("for("+collectionParamTypeName+" "+collectionEltName+" : ("+detachSourceType.getQualifiedSourceName()+"<"+collectionParamTypeName+">) "+detachSourceName+") {");
			String detachedElt = appendDetachingCode(collectionEltName, collectionParamType, detachMethodBody);
			detachMethodBody.append(collectionName+".add("+detachedElt+")");
			detachMethodBody.append("}");

			return collectionName;
		}
		else if(detachSourceType.isArray()!=null) {
			//TODO
			return null;
		}
		else if(Map.class.isAssignableFrom(detachSourceClass)) {
			//TODO
			return null;
		}
		else {
			if(ClassTypeHelper.isPrimitive(detachSourceClass) 
					|| String.class.equals(detachSourceClass)
					|| detachSourceClass.isEnum()) {
				return detachSourceName;
			}
			else {
				String varName = getVariableName();
				detachMethodBody.append(detachSourceClassName+" "+varName+" = null");
				
				detachMethodBody.append("if("+detachSourceName+" instanceof "+IDetachableProxy.class.getCanonicalName()+") {");
				
				detachMethodBody.append("if("+mapName+".containsKey("+detachSourceName+")) {");
				detachMethodBody.append(varName+" = ("+detachSourceClassName+") "+mapName+".get("+detachSourceName+")");
				detachMethodBody.append("}");
				detachMethodBody.append("else {");
				detachMethodBody.append(varName+" = ("+detachSourceClassName+") (("+IDetachableProxy.class.getCanonicalName()+")"+detachSourceName+").getDetachedModel("+mapName+")");
				detachMethodBody.append("}");
				
				detachMethodBody.append("}");
				detachMethodBody.append("else {");
				detachMethodBody.append(varName+" = "+detachSourceName);
				detachMethodBody.append("}");
				
				return varName;
			}
		}
		
	}
	

	private boolean ignoreField(JField field) {
		return field.isFinal();
	}


	public void setType(JClassType type) {
		this.type = type;
	}

	private String getVariableName() {
		return "var"+varCount++;
	}
	
}
